/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.buffer;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.buffer.MarkerBufferFactory;
import ch.iterate.mountainduck.fs.buffer.MarkerFileBuffer;
import ch.iterate.mountainduck.service.DiskUsageServiceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMarkerBufferFactory
implements MarkerBufferFactory {
    private static final Logger log = LogManager.getLogger((String)DefaultMarkerBufferFactory.class.getName());
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public MarkerBuffer create(Path file) {
        long limit;
        MarkerFileBuffer buffer = new MarkerFileBuffer(file);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create buffer for file %s", file));
        }
        try {
            limit = Math.min(DiskUsageServiceFactory.get().find((Local)buffer.getTemporary().getParent()).available, this.preferences.getLong("fs.buffer.limit"));
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure %s to determine free disk space", new Object[]{e}));
            limit = this.preferences.getLong("fs.buffer.limit");
        }
        return buffer.withLimit(limit);
    }
}

