/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.InodeFilenameComposer;
import ch.iterate.mountainduck.fs.ProxyFilesystemOperations;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferReadStrategy;
import ch.iterate.mountainduck.service.VolumeIconService;
import java.io.IOException;
import java.util.EnumSet;

public class VolumeIconServiceFilesystemOperations<Inode>
extends ProxyFilesystemOperations<Inode> {
    private final VolumeIconService iconService;
    private final FilesystemOperations<Inode> proxy;
    private final InodeFilenameComposer<Inode> composer;

    public VolumeIconServiceFilesystemOperations(FilesystemOperations<Inode> proxy, FileidMapper<Inode> fileid, VolumeIconService iconService) {
        super(proxy);
        this.proxy = proxy;
        this.composer = new InodeFilenameComposer<Inode>(fileid);
        this.iconService = iconService;
    }

    @Override
    public FilesystemOperations<Inode> open(Path workdir, Local mountpoint) throws BackgroundException {
        this.proxy.open(workdir, mountpoint);
        this.iconService.set(this.proxy.getHost(), workdir);
        return this;
    }

    @Override
    public void close() throws BackgroundException {
        this.iconService.unset();
        this.proxy.close();
    }

    @Override
    public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
        Path file = this.composer.compose(directory, filename, EnumSet.of(AbstractPath.Type.file));
        if (this.iconService.contains(file)) {
            MarkerBuffer buffer = this.iconService.asBuffer(file);
            PathAttributes attr = new PathAttributes();
            attr.setSize(buffer.length().longValue());
            return file.withAttributes(attr);
        }
        return this.proxy.find(directory, filename, flags);
    }

    @Override
    public PathAttributes getattr(Path file, boolean cached) throws BackgroundException {
        if (this.iconService.contains(file)) {
            MarkerBuffer buffer = this.iconService.asBuffer(file);
            PathAttributes attr = new PathAttributes();
            attr.setSize(buffer.length().longValue());
            return attr;
        }
        return this.proxy.getattr(file, cached);
    }

    @Override
    public int read(Path file, byte[] chunk, long offset, int count) throws BackgroundException {
        if (this.iconService.contains(file)) {
            try {
                return new BufferReadStrategy(this.iconService.asBuffer(file)).read(file, Long.valueOf(count), offset).read(chunk, 0, count);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        return this.proxy.read(file, chunk, offset, count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VolumeIconServiceFilesystemOperations{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

