/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimestampFilesystemDirectoryGenerations
implements FilesystemDirectoryGenerations {
    private static final Logger log = LogManager.getLogger((String)TimestampFilesystemDirectoryGenerations.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Map<CacheReference<Path>, Long> generations = new ConcurrentHashMap<CacheReference<Path>, Long>();

    @Override
    public Long get(Path directory) {
        if (this.preferences.getBoolean("fs.generation.cache.enable")) {
            if (this.generations.containsKey((Object)new FilesystemCacheReference(directory))) {
                if (this.preferences.getLong("fs.generation.cache.expiry.ms") > -1L) {
                    long now = System.nanoTime();
                    if (this.generations.get((Object)new FilesystemCacheReference(directory)) + this.preferences.getLong("fs.generation.cache.expiry.ms") < now) {
                        this.increment(directory);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(String.format("Use cached directory generation for %s", directory));
                }
            } else if (-1L == directory.attributes().getModificationDate()) {
                this.increment(directory);
            } else {
                this.increment(directory);
            }
            return this.generations.get((Object)new FilesystemCacheReference(directory));
        }
        return directory.attributes().getModificationDate();
    }

    @Override
    public Long increment(Path directory) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Increment generation of directory %s", directory));
        }
        if (this.generations.containsKey((Object)new FilesystemCacheReference(directory))) {
            long now = System.currentTimeMillis();
            if (now > this.generations.get((Object)new FilesystemCacheReference(directory))) {
                this.generations.put((CacheReference<Path>)new FilesystemCacheReference(directory), now);
            } else {
                log.debug(String.format("Skip updating generation to %s for %s", now, directory));
            }
        } else if (-1L == directory.attributes().getModificationDate()) {
            this.generations.put((CacheReference<Path>)new FilesystemCacheReference(directory), System.currentTimeMillis());
        } else {
            this.generations.put((CacheReference<Path>)new FilesystemCacheReference(directory), directory.attributes().getModificationDate());
        }
        return this.generations.get((Object)new FilesystemCacheReference(directory));
    }

    @Override
    public void clear() {
        this.generations.clear();
    }

    @Override
    public void remove(Path directory) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove generation of directory %s", directory));
        }
        this.generations.remove((Object)new FilesystemCacheReference(directory));
    }
}

