/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemporaryFileMarker {
    private static final Logger log = LogManager.getLogger((String)TemporaryFileMarker.class.getName());
    public static final String KEY_TEMPORARY = "fs.touch.temporary";

    public Path set(Path file) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Set temporary flag on file %s", file));
        }
        HashMap<String, String> properties = new HashMap<String, String>(file.attributes().getCustom());
        properties.put(KEY_TEMPORARY, String.valueOf(true));
        file.attributes().setCustom(properties);
        return file;
    }

    public boolean contains(Path file) {
        return file.attributes().getCustom().containsKey(KEY_TEMPORARY);
    }

    public Path remove(Path file) {
        if (this.contains(file)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Remove temporary flag on file %s", file));
            }
            file.attributes().getCustom().remove(KEY_TEMPORARY);
        }
        return file;
    }
}

