/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ExpiringObjectHolder;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.ThrottledInputStream;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.exception.FilesystemIOExceptionMappingService;
import ch.iterate.mountainduck.exception.InvalidOffsetException;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilenameMatchPathPredicate;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemAclWorker;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCachingAttributesWorker;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemCreateDirectoryWorker;
import ch.iterate.mountainduck.fs.FilesystemDeleteWorker;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListWorker;
import ch.iterate.mountainduck.fs.FilesystemLockWorker;
import ch.iterate.mountainduck.fs.FilesystemMoveWorker;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemPathCache;
import ch.iterate.mountainduck.fs.FilesystemPermissionWorker;
import ch.iterate.mountainduck.fs.FilesystemQuotaWorker;
import ch.iterate.mountainduck.fs.FilesystemReaders;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import ch.iterate.mountainduck.fs.FilesystemSymlinkWorker;
import ch.iterate.mountainduck.fs.FilesystemTimestampWorker;
import ch.iterate.mountainduck.fs.FilesystemTouchWorker;
import ch.iterate.mountainduck.fs.FilesystemUnlockWorker;
import ch.iterate.mountainduck.fs.FilesystemWriters;
import ch.iterate.mountainduck.fs.InodeFilenameComposer;
import ch.iterate.mountainduck.fs.InodeFilesystemPathCache;
import ch.iterate.mountainduck.fs.LockPatternService;
import ch.iterate.mountainduck.fs.PathFilenameComposer;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.indexer.DisabledDirectoryIndexer;
import ch.iterate.mountainduck.io.DelegatingReadStrategy;
import ch.iterate.mountainduck.io.DelegatingWriteStrategy;
import ch.iterate.mountainduck.io.NullReadStrategy;
import ch.iterate.mountainduck.io.ReadStrategy;
import ch.iterate.mountainduck.io.WriteStrategy;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.metadata.DisabledMetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.DisabledSyncQueue;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionFilesystemOperations<Inode>
implements FilesystemOperations<Inode> {
    private static final Logger log = LogManager.getLogger((String)SessionFilesystemOperations.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    public static final String SET_MODIFICATION_DATE = "set_modification_date";
    public static final String SET_PERMISSIONS = "set_permissions";
    private final Host bookmark;
    private final FilesystemCache cache;
    private final FilesystemSessionPool pool;
    private final FileidMapper<Inode> fileid;
    private final FilesystemDirectoryGenerations generations;
    private final FilesystemWriters writers = new FilesystemWriters();
    private final FilesystemReaders readers = new FilesystemReaders();
    private final FilesystemBuffers buffers = new FilesystemBuffers();
    private final LRUCache<FilesystemCacheReference, PathAttributes> attributesCache = LRUCache.usingLoader(reference -> reference.getFile().attributes(), (long)this.preferences.getLong("fs.sync.attributes.cache.size"));
    private final Set<FilesystemCacheReference> owners = ConcurrentHashMap.newKeySet();
    private final Map<FilesystemCacheReference, String> locks = new ConcurrentHashMap<FilesystemCacheReference, String>();
    private final Controller controller;
    private final ExpiringObjectHolder<Quota.Space> quota = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("fs.quota.ttl")));
    private final InodeFilenameComposer<Inode> composer;
    private Path workdir;

    public SessionFilesystemOperations(Controller controller, Host bookmark, FilesystemSessionPool pool, FileidMapper<Inode> fileid, FilesystemDirectoryGenerations generations) {
        this.controller = controller;
        this.bookmark = bookmark;
        this.pool = pool;
        this.fileid = fileid;
        this.generations = generations;
        this.cache = new InodeFilesystemPathCache<Inode>(new FilesystemPathCache(this.buffers, this.writers, this.readers, generations), fileid);
        this.composer = new InodeFilenameComposer<Inode>(fileid);
    }

    protected SessionFilesystemOperations(Controller controller, Host bookmark, FilesystemSessionPool pool, FileidMapper<Inode> fileid, FilesystemDirectoryGenerations generations, FilesystemCache cache) {
        this.controller = controller;
        this.bookmark = bookmark;
        this.pool = pool;
        this.fileid = fileid;
        this.generations = generations;
        this.cache = cache;
        this.composer = new InodeFilenameComposer<Inode>(fileid);
    }

    @Override
    public ConnectMode getMode() {
        return ConnectMode.online;
    }

    @Override
    public DirectoryIndexer getIndexer() {
        return new DisabledDirectoryIndexer();
    }

    @Override
    public SyncQueue getQueue() {
        return new DisabledSyncQueue();
    }

    @Override
    public MetadataService<?> getMetadataService() {
        return new DisabledMetadataService();
    }

    @Override
    public FilesystemCache getCache() {
        return this.cache;
    }

    @Override
    public FilesystemSessionPool getPool() {
        return this.pool;
    }

    @Override
    public Path getWorkdir() {
        return this.workdir;
    }

    @Override
    public FilesystemDirectoryGenerations getGenerations() {
        return this.generations;
    }

    @Override
    public PathFilenameComposer getComposer() {
        return this.composer;
    }

    @Override
    public FileHistory getHistory() {
        return FileHistory.EMPTY;
    }

    @Override
    public LocalCache<?> getLocalCache() {
        return LocalCache.EMPTY;
    }

    @Override
    public FileOverlayIconService.Badge getBadge(Path file) {
        return FileOverlayIconService.Badge.online;
    }

    @Override
    public FileStatusService.Status getStatus(Path file) {
        if (this.writers.containsKey((Object)new FilesystemCacheReference(file))) {
            return new FileStatusService.Status(FileStatusService.SyncState.inprogress);
        }
        return new FileStatusService.Status(FileStatusService.SyncState.remote);
    }

    @Override
    public void invalidate(Path workdir) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Invalidate directory %s", workdir));
        }
        this.generations.increment(workdir);
        this.cache.invalidate((Referenceable)workdir);
    }

    @Override
    public Filesystem.State getMountStatus() {
        switch (this.pool.getState()) {
            case opening: 
            case closing: {
                return Filesystem.State.busy;
            }
            case open: {
                if (this.cache.isEmpty()) {
                    return Filesystem.State.busy;
                }
                return Filesystem.State.idle;
            }
            case closed: {
                return Filesystem.State.idle;
            }
        }
        return Filesystem.State.closed;
    }

    @Override
    public FilesystemOperations<Inode> open(Path workdir, Local mountpoint) {
        this.workdir = workdir;
        return this;
    }

    @Override
    public void close() throws BackgroundException {
        this.cache.clear();
        this.buffers.clear();
        for (Map.Entry<FilesystemCacheReference, String> e : this.locks.entrySet()) {
            this.pool.await(new FilesystemUnlockWorker(LockPatternService.standard, this, this.owners, e.getKey().getFile(), e.getValue()));
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Close connection pool %s", this.pool));
        }
        this.pool.shutdown();
    }

    @Override
    public Quota.Space quota(Path workdir) throws BackgroundException {
        if (null == this.quota.get()) {
            Quota.Space space = this.pool.await(new FilesystemQuotaWorker(this.controller, this));
            if (log.isInfoEnabled()) {
                log.info(String.format("Set available quota to %s", space));
            }
            this.quota.set((Object)space);
        }
        return (Quota.Space)this.quota.get();
    }

    @Override
    public MarkerBuffer buffer(Path file) {
        return this.buffers.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(Path file, FilesystemCallbacks.Mode flags, Long allocate, Application application) throws BackgroundException {
        MarkerBuffer buffer;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open file %s in %s mode with allocation size %d", new Object[]{file, flags, allocate}));
        }
        switch (flags) {
            case write_truncate: {
                if (this.contains(file, FilesystemCallbacks.Mode.write) && 0L == allocate) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Close writer for file %s", file));
                    }
                    this.close(file, FilesystemCallbacks.Mode.write, application, false);
                }
            }
            case write: {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Create new delegating write strategy for file %s", file));
                }
                if (!this.contains(file, FilesystemCallbacks.Mode.write)) {
                    buffer = this.buffers.getOrCreate(file);
                    if (allocate > 0L) {
                        buffer.truncate(allocate);
                    }
                    FilesystemWriters filesystemWriters = this.writers;
                    synchronized (filesystemWriters) {
                        this.writers.put(new FilesystemCacheReference(file), new DelegatingWriteStrategy(this, this.cache, flags, buffer, (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller), FilesystemFilenameBlacklist.temporary, FilesystemFilenameBlacklist.lockowner));
                    }
                } else if (allocate > 0L) {
                    buffer = this.buffers.get(file);
                    buffer.truncate(allocate);
                }
                if (!FilesystemFilenameBlacklist.lockinitiators.contains(file)) break;
                this.lock(file);
            }
        }
        switch (flags) {
            case read: {
                if (!this.contains(file, FilesystemCallbacks.Mode.read)) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Create new offset read strategy for file %s", file));
                    }
                    if ((buffer = this.buffers.getOrCreate(file)).getState() == MarkerBuffer.State.closed && allocate > 0L) {
                        buffer.truncate(allocate);
                    }
                    PathAttributes attr = this.getattr(file, this.preferences.getBoolean("fs.open.cache.enable"));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Read latest attributes %s for file %s", attr, file));
                    }
                    FilesystemReaders filesystemReaders = this.readers;
                    synchronized (filesystemReaders) {
                        this.readers.put(new FilesystemCacheReference(file), new DelegatingReadStrategy(this, this.buffers, this.cache, (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller)));
                        break;
                    }
                }
                if (!log.isDebugEnabled()) break;
                log.debug(String.format("Ignore open with flag %s for file %s with reader %s", new Object[]{flags, file, this.readers.get((Object)new FilesystemCacheReference(file))}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Path file, FilesystemCallbacks.Mode flags) {
        switch (flags) {
            case read: {
                FilesystemReaders filesystemReaders = this.readers;
                synchronized (filesystemReaders) {
                    return this.readers.containsKey((Object)new FilesystemCacheReference(file));
                }
            }
            case write_truncate: 
            case write: {
                FilesystemWriters filesystemWriters = this.writers;
                synchronized (filesystemWriters) {
                    return this.writers.containsKey((Object)new FilesystemCacheReference(file));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TransferStatus close(Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
        switch (flags) {
            case read: {
                if (!this.contains(file, FilesystemCallbacks.Mode.read)) {
                    if (!log.isDebugEnabled()) return null;
                    log.debug(String.format("No reader to close found for %s", file));
                    return null;
                }
                FilesystemReaders filesystemReaders = this.readers;
                synchronized (filesystemReaders) {
                    ReadStrategy reader = (ReadStrategy)this.readers.get((Object)new FilesystemCacheReference(file));
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Close reader %s for %s", reader, file));
                    }
                    try {
                        reader.close(file);
                    }
                    catch (ConnectionTimeoutException e) {
                        log.warn(String.format("Ignore timeout closing reader for %s", file));
                    }
                    finally {
                        this.readers.remove((Object)new FilesystemCacheReference(file));
                    }
                    return null;
                }
            }
            case write_truncate: 
            case write: {
                if (this.contains(file, FilesystemCallbacks.Mode.write)) {
                    FilesystemWriters filesystemWriters = this.writers;
                    synchronized (filesystemWriters) {
                        WriteStrategy writer = (WriteStrategy)this.writers.get((Object)new FilesystemCacheReference(file));
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Close writer %s for %s", writer, file));
                        }
                        try {
                            TransferStatus e = writer.close(file);
                            return e;
                        }
                        catch (ConnectionTimeoutException e) {
                            log.warn(String.format("Ignore timeout closing writer for %s", file));
                            TransferStatus transferStatus = null;
                            // MONITOREXIT @DISABLED, blocks:[18, 3, 26, 11, 12, 14] lbl39 : MonitorExitStatement: MONITOREXIT : var5_6
                            if (!releaseLock) return transferStatus;
                            this.unlock(file);
                            return transferStatus;
                        }
                        finally {
                            this.writers.remove((Object)new FilesystemCacheReference(file));
                            this.attributesCache.remove((Object)new FilesystemCacheReference(file));
                        }
                    }
                }
                if (!log.isDebugEnabled()) return null;
                log.debug(String.format("No writer to close found for %s", file));
                return null;
                finally {
                    if (releaseLock) {
                        this.unlock(file);
                    }
                }
            }
        }
        log.error(String.format("Unhandled flag %s", new Object[]{flags}));
        return null;
    }

    @Override
    public Inode mkdir(Path directory) throws BackgroundException {
        return this.fileid.getOrCreate(this.pool.await(new FilesystemCreateDirectoryWorker(this.cache, directory)));
    }

    @Override
    public Inode touch(Path file) throws BackgroundException {
        Path result = (Path)this.pool.await(new FilesystemTouchWorker(this, this.buffers, this.cache, file, FilesystemFilenameBlacklist.temporary, FilesystemFilenameBlacklist.lockowner));
        if (FilesystemFilenameBlacklist.lockowner.contains(result)) {
            this.owners.add(new FilesystemCacheReference(result));
        }
        return this.fileid.getOrCreate(result);
    }

    @Override
    public void truncate(Path file, long size) throws BackgroundException {
        MarkerBuffer buffer = this.buffers.get(file);
        long current = buffer.length();
        this.open(file, FilesystemCallbacks.Mode.write_truncate, size, Application.notfound);
        if (size == 0L && !new TemporaryFileMarker().contains(file)) {
            try {
                this.write(file, 0L, 0L).write(new byte[0]);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        int diff = Long.valueOf(size - current).intValue();
        buffer.truncate(size);
        if (diff > 0) {
            try {
                buffer.write(new byte[diff], current);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }

    @Override
    public Inode symlink(Path file, Path target) throws BackgroundException {
        this.pool.await(new FilesystemSymlinkWorker(this.cache, file, target));
        return this.fileid.getOrCreate(file);
    }

    @Override
    public Map<Path, Path> rename(Path file, Path target) throws BackgroundException {
        Map result = (Map)this.pool.await(new FilesystemMoveWorker(this.controller, this, this.buffers, this.writers, this.cache, file, target));
        for (Map.Entry entry : result.entrySet()) {
            this.attributesCache.remove((Object)new FilesystemCacheReference((Path)entry.getKey()));
            this.attributesCache.remove((Object)new FilesystemCacheReference((Path)entry.getValue()));
        }
        return result;
    }

    @Override
    public Set<Path> delete(Path file) throws BackgroundException {
        List list = (List)this.pool.await(new FilesystemDeleteWorker(this.controller, this, this.cache, file, !FilesystemFilenameBlacklist.lockowner.contains(file)));
        for (Path f : list) {
            if (FilesystemFilenameBlacklist.lockowner.contains(file)) {
                this.owners.remove((Object)new FilesystemCacheReference(f));
                Pattern pattern = LockPatternService.standard.match(file);
                for (FilesystemCacheReference r : this.locks.keySet()) {
                    if (!pattern.matcher(r.getFile().getName()).matches()) continue;
                    this.unlock(r.getFile());
                }
            }
            this.fileid.remove(f);
            this.attributesCache.remove((Object)new FilesystemCacheReference(f));
        }
        return new HashSet<Path>(list);
    }

    @Override
    public Worker<AttributedList<Path>> list(Path directory, FilesystemListProgressListener listener, long fromCookie) throws BackgroundException {
        FilesystemListWorker worker = new FilesystemListWorker(this, this.buffers, this.writers, this.cache, directory, listener);
        this.pool.execute(worker.withCache(0L == fromCookie ? this.preferences.getBoolean("fs.readdir.cache.enable") : true).withCacheExpiry(0L == fromCookie ? this.preferences.getLong("fs.readdir.cache.expiry.ms") : -1L));
        return worker;
    }

    @Override
    public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
        if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)filename)) {
            return this.workdir;
        }
        Path file = this.composer.compose(directory, filename, EnumSet.of(AbstractPath.Type.directory));
        if (new FilesystemCacheReference(file).test(this.workdir)) {
            return this.workdir;
        }
        Path cached = (Path)this.cache.get((Referenceable)file.getParent()).filter((Filter)new FilesystemListFilter()).find((Predicate)((Object)new FilenameMatchPathPredicate(file, this.bookmark.getProtocol().getCaseSensitivity())));
        if (null == cached) {
            if (FilesystemFilenameBlacklist.blacklist.contains(file)) {
                log.debug(String.format("Ignore lookup for %s", file));
                throw new NotfoundException(filename);
            }
            if (flags == FilesystemCallbacks.Flags.offline) {
                throw new NotfoundException(filename);
            }
            FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(this.bookmark);
            FilesystemListWorker worker = new FilesystemListWorker(this, this.buffers, this.writers, this.cache, file.getParent(), listener).withCache(this.preferences.getBoolean("fs.find.cache.enable"));
            this.pool.execute(worker);
            Path found = listener.search(filename);
            worker.cancel();
            return found.withAttributes(this.getattr(found));
        }
        return cached.withAttributes(this.getattr(cached));
    }

    @Override
    public EnumSet<AbstractPath.Type> type(Path file) {
        return file.getType();
    }

    @Override
    public PathAttributes getattr(Path file, boolean cached) throws BackgroundException {
        PathAttributes attr;
        PathAttributes cachedAttr;
        if (!(cached || !FilesystemFilenameBlacklist.nocache.contains(file) || FilesystemFilenameBlacklist.blacklist.contains(file) || FilesystemFilenameBlacklist.lockowner.contains(file) || this.contains(file, FilesystemCallbacks.Mode.write))) {
            PathAttributes attr2 = this.pool.await(new FilesystemCachingAttributesWorker(this.cache, file).withCache(this.preferences.getBoolean("fs.getattr.cache.enable")).withCacheExpiry(this.preferences.getLong("fs.getattr.cache.expiry.ms")));
            this.attributesCache.put((Object)new FilesystemCacheReference(file), (Object)attr2);
            return attr2;
        }
        PathAttributes pathAttributes = cachedAttr = this.preferences.getBoolean("fs.attributes.cache.enable") ? (PathAttributes)this.attributesCache.get((Object)new FilesystemCacheReference(file)) : file.attributes();
        if (file.attributes() == cachedAttr) {
            attr = new PathAttributes(file.attributes());
        } else if (Math.abs(file.attributes().getModificationDate() - cachedAttr.getModificationDate()) > this.preferences.getLong("fs.attributes.cache.mtime.threshold.ms")) {
            this.attributesCache.remove((Object)new FilesystemCacheReference(file));
            attr = new PathAttributes(file.attributes());
        } else {
            attr = new PathAttributes(file.attributes());
            attr.setModificationDate(cachedAttr.getModificationDate());
        }
        if (file.isFile()) {
            MarkerBuffer buffer = this.buffer(file);
            if (buffer.getState() == MarkerBuffer.State.closed) {
                if (-1L == file.attributes().getSize()) {
                    log.warn(String.format("Unknown file size for %s", file));
                    attr.setSize(0L);
                } else {
                    attr.setSize(file.attributes().getSize());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Set file size for %s from buffer %s", file, buffer));
                }
                attr.setSize(buffer.length().longValue());
            }
        } else if (-1L == file.attributes().getSize()) {
            attr.setSize(0L);
        }
        return attr;
    }

    @Override
    public boolean setattr(Path file, long timestamp) throws BackgroundException {
        if (this.preferences.getBoolean("fs.sync.timestamp.threshold.enable")) {
            switch (this.getStatus(file).getState()) {
                case inprogress: {
                    break;
                }
                default: {
                    if (timestamp + (long)this.preferences.getInteger("fs.sync.timestamp.threshold.ms") <= System.currentTimeMillis()) break;
                    log.warn(String.format("Skip setting timestamp %d for file %s", timestamp, file));
                    return false;
                }
            }
        }
        if (file.attributes().getModificationDate() == timestamp) {
            log.warn(String.format("Ignore setting equal timestamp %s for file %s", timestamp, file));
            return false;
        }
        file.attributes().setModificationDate(timestamp);
        if (this.preferences.getBoolean("fs.setattr.mtime")) {
            if (new TemporaryFileMarker().contains(file) || this.contains(file, FilesystemCallbacks.Mode.write)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Skip setting timestamp for %s", file));
                }
                HashMap<String, String> properties = new HashMap<String, String>(file.attributes().getCustom());
                properties.put(SET_MODIFICATION_DATE, String.valueOf(true));
                file.attributes().setCustom(properties);
            } else {
                try {
                    this.pool.await(new FilesystemTimestampWorker(this, file, timestamp));
                }
                catch (UnsupportedException e) {
                    log.warn(String.format("Ignore failure %s", new Object[]{e}));
                }
            }
        }
        this.attributesCache.put((Object)new FilesystemCacheReference(file), (Object)file.attributes());
        return true;
    }

    @Override
    public boolean setattr(Path file, Permission permission) throws BackgroundException {
        if (file.attributes().getPermission().equals((Object)permission)) {
            log.warn(String.format("Ignore setting equal permission %s for file %s", permission, file));
            return false;
        }
        file.attributes().setPermission(permission);
        if (new TemporaryFileMarker().contains(file) || this.contains(file, FilesystemCallbacks.Mode.write)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skip setting permissions for %s", file));
            }
            HashMap<String, String> properties = new HashMap<String, String>(file.attributes().getCustom());
            properties.put(SET_PERMISSIONS, String.valueOf(true));
            file.attributes().setCustom(properties);
        } else {
            if (this.preferences.getBoolean("fs.setattr.chmod")) {
                try {
                    this.pool.execute(new FilesystemPermissionWorker(file, permission));
                }
                catch (UnsupportedException e) {
                    log.warn(String.format("Ignore failure %s", new Object[]{e}));
                }
            }
            if (this.preferences.getBoolean("fs.setattr.acl")) {
                try {
                    this.pool.execute(new FilesystemAclWorker(file, permission));
                }
                catch (UnsupportedException e) {
                    log.warn(String.format("Ignore failure %s", new Object[]{e}));
                }
            }
        }
        this.attributesCache.put((Object)new FilesystemCacheReference(file), (Object)file.attributes());
        return true;
    }

    protected String normalize(Path workdir, String input) {
        if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)input)) {
            return input;
        }
        if (workdir.isRoot()) {
            return PathNormalizer.normalize((String)input, (boolean)true);
        }
        return String.format("%s%s", workdir.getAbsolute(), PathNormalizer.normalize((String)input, (boolean)true));
    }

    @Override
    public int read(final Path file, final byte[] chunk, final long offset, final int count) throws BackgroundException {
        return this.pool.await(new Worker<Integer>(){

            public Integer run(Session<?> session) throws BackgroundException {
                try {
                    return FilesystemCallbacks.read(SessionFilesystemOperations.this.read(file, Long.valueOf(count), offset), chunk, 0, count);
                }
                catch (IOException e) {
                    throw new FilesystemIOExceptionMappingService().map(e);
                }
            }
        });
    }

    public InputStream read(Path file, Long count, Long offset) throws BackgroundException {
        long allocation;
        MarkerBuffer buffer;
        if (!this.contains(file, FilesystemCallbacks.Mode.read)) {
            PathAttributes attr = this.getattr(file);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Open file with remote file %s size %d", file, attr.getSize()));
            }
            this.open(file, FilesystemCallbacks.Mode.read, attr.getSize(), Application.notfound);
        }
        ReadStrategy reader = (ReadStrategy)this.readers.get((Object)new FilesystemCacheReference(file));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return reader %s for file %s", reader, file));
        }
        if ((buffer = this.buffers.get(file)).getState() == MarkerBuffer.State.closed) {
            PathAttributes attr = this.getattr(file);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Set allocation size from file size %s", attr.getSize()));
            }
            allocation = attr.getSize();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Set allocation size from buffer %s", buffer));
            }
            allocation = buffer.length();
        }
        Long length = Long.min(count, allocation - offset);
        try {
            InputStream in;
            if (offset >= allocation) {
                log.error(String.format("Offset %d out of range for file %s with length %d", offset, file, allocation));
                throw new InvalidOffsetException(String.format("Invalid offset %d for file size %s", offset, allocation));
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Open file with remote file %s size %d", file, length));
            }
            if (null == (in = reader.read(file, length, offset))) {
                log.warn(String.format("Failure opening input stream for file %s", file));
                throw new AccessDeniedException(String.format("Failure opening stream for file %s", file));
            }
            BandwidthThrottle throttle = new BandwidthThrottle(this.preferences.getFloat("queue.download.bandwidth.bytes"));
            if (throttle.getRate() != -1.0f) {
                log.warn(String.format("Throttle read from %s with %s", file, throttle));
                return new ThrottledInputStream(in, throttle);
            }
            return in;
        }
        catch (InvalidOffsetException e) {
            log.warn(String.format("Return null read stream for file %s with invalid read offset %d", file, offset));
            return new NullReadStrategy(0L).read(file, 0L, 0L);
        }
    }

    @Override
    public int write(final Path file, final byte[] chunk, final int count, final long offset) throws BackgroundException {
        return this.pool.await(new Worker<Integer>(){

            public Integer run(Session<?> session) throws BackgroundException {
                try {
                    IOUtils.write((byte[])(chunk.length > count ? Arrays.copyOf(chunk, count) : chunk), (OutputStream)SessionFilesystemOperations.this.write(file, Long.valueOf(count), offset));
                    return count;
                }
                catch (IOException e) {
                    throw new FilesystemIOExceptionMappingService().map(e);
                }
            }
        });
    }

    public OutputStream write(Path file, Long length, Long offset) throws BackgroundException {
        StatusOutputStream out;
        if (!this.contains(file, FilesystemCallbacks.Mode.write)) {
            PathAttributes attr;
            MarkerBuffer buffer = this.buffers.get(file);
            long allocation = buffer.getState() == MarkerBuffer.State.closed ? (-1L != (attr = this.getattr(file)).getSize() ? attr.getSize() : 0L) : buffer.length();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Open file with remote file %s size %d", file, allocation));
            }
            this.open(file, allocation == 0L ? FilesystemCallbacks.Mode.write_truncate : FilesystemCallbacks.Mode.write, allocation, Application.notfound);
        }
        WriteStrategy writer = (WriteStrategy)this.writers.get((Object)new FilesystemCacheReference(file));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return writer %s for file %s", writer, file));
        }
        if (null == (out = writer.write(file, length, offset))) {
            log.warn(String.format("Failure opening output stream for file %s", file));
            throw new AccessDeniedException(String.format("Failure opening stream for file %s", file));
        }
        BandwidthThrottle throttle = new BandwidthThrottle(this.preferences.getFloat("queue.upload.bandwidth.bytes"));
        if (throttle.getRate() != -1.0f) {
            log.warn(String.format("Throttle write to %s with %s", file, throttle));
            return new ThrottledOutputStream((OutputStream)out, throttle);
        }
        return out;
    }

    @Override
    public Object lock(Path file) throws BackgroundException {
        String existingLockId = this.getLock(file);
        if (existingLockId != null) {
            log.warn(String.format("File %s is already locked with id %s", file, existingLockId));
            return existingLockId;
        }
        try {
            String lockId = this.pool.await(new FilesystemLockWorker(LockPatternService.standard, this.owners, file));
            if (lockId != null) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Lock file %s with id %s", file, lockId));
                }
                this.locks.putIfAbsent(new FilesystemCacheReference(file), lockId);
                return lockId;
            }
        }
        catch (LockedException e) {
            this.cache.invalidate((Referenceable)file.getParent());
            log.warn(String.format("File %s is locked on server", file));
            throw e;
        }
        catch (BackgroundException e) {
            log.warn(String.format("Ignore failure %s trying to obtain lock for %s", new Object[]{e, file}));
        }
        return null;
    }

    @Override
    public void unlock(Path file) throws BackgroundException {
        if (!this.locks.containsKey((Object)new FilesystemCacheReference(file))) {
            log.warn(String.format("Unable to find a lock for file %s", file));
        } else {
            String lockId = this.locks.get((Object)new FilesystemCacheReference(file));
            if (log.isInfoEnabled()) {
                log.info(String.format("Unlock file %s with id %s", file, lockId));
            }
            if (this.pool.await(new FilesystemUnlockWorker(LockPatternService.standard, this, this.owners, file, lockId)) != null) {
                this.locks.remove((Object)new FilesystemCacheReference(file));
            }
        }
    }

    @Override
    public String getLock(Path file) {
        return this.locks.getOrDefault((Object)new FilesystemCacheReference(file), null);
    }

    @Override
    public FilesystemWriters writers() {
        return this.writers;
    }

    @Override
    public FilesystemReaders readers() {
        return this.readers;
    }

    @Override
    public FilesystemBuffers buffers() {
        return this.buffers;
    }

    @Override
    public Path reverse(Inode inode) throws NotfoundException {
        return this.fileid.reverse(inode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionFilesystemOperations)) {
            return false;
        }
        SessionFilesystemOperations that = (SessionFilesystemOperations)o;
        return Objects.equals(this.bookmark, that.bookmark);
    }

    public int hashCode() {
        return Objects.hash(this.bookmark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionFilesystem{");
        sb.append("bookmark=").append(this.bookmark);
        sb.append(", controller=").append(this.controller);
        sb.append('}');
        return sb.toString();
    }

    static {
        new MappingMimeTypeService().getMime("");
    }
}

