/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.pool.SessionPool;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchedulerMountRegistryListener
implements FilesystemMountRegistry.Listener {
    private static final Logger log = LogManager.getLogger((String)SchedulerMountRegistryListener.class.getName());
    private final Map<Filesystem, Scheduler> workers = new HashMap<Filesystem, Scheduler>();

    @Override
    public void mounted(Filesystem fs) {
        Scheduler scheduler = (Scheduler)fs.getHost().getProtocol().getFeature(Scheduler.class);
        if (scheduler != null) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Run repeating scheduler %s for mount %s", scheduler, fs));
            }
            this.workers.put(fs, scheduler);
            scheduler.repeat((SessionPool)fs.getPool(), (PasswordCallback)new DisabledPasswordCallback());
        }
    }

    @Override
    public void unmounted(Filesystem fs) {
        Scheduler worker = this.workers.remove(fs);
        if (worker != null) {
            worker.shutdown();
        }
    }
}

