/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegexFilesystemFilenameBlacklist
implements FilesystemFilenameBlacklist {
    private final List<String> blacklist;
    private final List<Pattern> patterns = new ArrayList<Pattern>();

    public RegexFilesystemFilenameBlacklist(List<String> blacklist) {
        this.blacklist = blacklist;
        for (String s : blacklist) {
            this.patterns.add(Pattern.compile(s));
        }
    }

    @Override
    public boolean contains(Path file) {
        Path t = file;
        while (!t.isRoot()) {
            if (this.contains(t.getName())) {
                return true;
            }
            t = t.getParent();
        }
        return false;
    }

    @Override
    public boolean contains(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        if (this.blacklist.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

