/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.QuotaFailureDiagnostics;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotificationServiceAlertCallback
implements AlertCallback {
    private static final Logger log = LogManager.getLogger(NotificationServiceAlertCallback.class);
    private final NotificationService notification;

    public NotificationServiceAlertCallback() {
        this(NotificationServiceFactory.get());
    }

    public NotificationServiceAlertCallback(NotificationService notification) {
        this.notification = notification;
    }

    public boolean alert(Host bookmark, BackgroundException failure, StringBuilder transcript) {
        if (log.isWarnEnabled()) {
            log.warn(String.format("Display notification for failure %s", new Object[]{failure}));
        }
        if (null != failure.getFile() && FilesystemFilenameBlacklist.blacklist.contains(failure.getFile().getName())) {
            return false;
        }
        FailureDiagnostics.Type type = new QuotaFailureDiagnostics().determine(failure);
        switch (type) {
            case quota: {
                this.notification.notify(BookmarkNameProvider.toString((Host)bookmark), StringUtils.isNotBlank((CharSequence)new HostPreferences(bookmark).getProperty("quota.notification.url")) ? new HostPreferences(bookmark).getProperty("quota.notification.url") : new DefaultProviderHelpService().help(bookmark.getProtocol()), failure.getMessage(), failure.getDetail(false), LocaleFactory.localizedString((String)"Review\u2026", (String)"Localizable"));
                break;
            }
            default: {
                this.notification.notify(BookmarkNameProvider.toString((Host)bookmark), "", failure.getMessage(), failure.getDetail(false), LocaleFactory.localizedString((String)"Show", (String)"Localizable"));
            }
        }
        return false;
    }
}

