/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.LockPatternService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MicrosoftOfficeLockPatternService
implements LockPatternService {
    private static final Preferences preferences = PreferencesFactory.get();
    private final Pattern owner = Pattern.compile("~\\$.*");
    private final Pattern files = Pattern.compile(preferences.getProperty("fs.lock.filenames.regexp.microsoftoffice"));

    @Override
    public Pattern match(Path file) {
        if (this.owner.matcher(file.getName()).matches()) {
            return Pattern.compile(".{0,2}" + Pattern.quote(StringUtils.removeStart((String)file.getName(), (String)"~$")));
        }
        return null;
    }

    @Override
    public Set<Path> derive(Path file) {
        if (!this.files.matcher(file.getName()).matches()) {
            return Collections.emptySet();
        }
        switch (file.getExtension()) {
            case "doc": 
            case "docx": {
                switch (StringUtils.length((CharSequence)FilenameUtils.removeExtension((String)file.getName()))) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return Collections.singleton(new Path(file.getParent(), String.format("~$%s", file.getName()), EnumSet.of(AbstractPath.Type.file)));
                    }
                    case 7: {
                        return Collections.singleton(new Path(file.getParent(), String.format("~$%s", file.getName().substring(1)), EnumSet.of(AbstractPath.Type.file)));
                    }
                }
                return Collections.singleton(new Path(file.getParent(), String.format("~$%s", file.getName().substring(2)), EnumSet.of(AbstractPath.Type.file)));
            }
        }
        return Collections.singleton(new Path(file.getParent(), String.format("~$%s", file.getName()), EnumSet.of(AbstractPath.Type.file)));
    }
}

