/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.LockPatternService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MicrosoftAccessLockPatternService
implements LockPatternService {
    private final Pattern owner = Pattern.compile(".*\\.laccdb");
    private final Pattern files = Pattern.compile(PreferencesFactory.get().getProperty("fs.lock.filenames.regexp.microsoftaccess"));

    @Override
    public Pattern match(Path file) {
        if (this.owner.matcher(file.getName()).matches()) {
            return Pattern.compile(String.format("%saccdb", Pattern.quote(StringUtils.removeEnd((String)file.getName(), (String)file.getExtension()))));
        }
        return null;
    }

    @Override
    public Set<Path> derive(Path file) {
        if (!this.files.matcher(file.getName()).matches()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new Path(file.getParent(), String.format("%s.laccdb", FilenameUtils.removeExtension((String)file.getName())), EnumSet.of(AbstractPath.Type.file)));
    }
}

