/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LongFileidMapper
implements FileidMapper<Long> {
    private static final Logger log = LogManager.getLogger((String)LongFileidMapper.class.getName());
    private static final long FILEID_ROOT = Long.MAX_VALUE;
    private static final long FILEID_FREE = Long.MIN_VALUE;
    private final AtomicLong counter = new AtomicLong(Long.MAX_VALUE);
    private final BidiMap<Long, FilesystemCacheReference> fileid = new DualHashBidiMap();

    @Override
    public Long toInode(long inodeNumber) {
        return inodeNumber;
    }

    @Override
    public long fromInode(Long inode) {
        return inode;
    }

    public synchronized Path get(long fileId) throws NotfoundException {
        FilesystemCacheReference reference = (FilesystemCacheReference)((Object)this.fileid.get((Object)fileId));
        if (null == reference) {
            throw new NotfoundException(String.format("No mapping for fileId %s", fileId));
        }
        return reference.getFile();
    }

    @Override
    public synchronized Long updateOrCreate(Path file) {
        FilesystemCacheReference reference = new FilesystemCacheReference(file);
        if (this.fileid.containsValue((Object)reference)) {
            Long key = (Long)this.fileid.getKey((Object)reference);
            this.fileid.replace((Object)key, (Object)reference);
            return key;
        }
        return this.create(file);
    }

    @Override
    public synchronized Long getOrCreate(Path file) {
        if (this.fileid.containsValue((Object)new FilesystemCacheReference(file))) {
            return (Long)this.fileid.getKey((Object)new FilesystemCacheReference(file));
        }
        return this.create(file);
    }

    private long create(Path file) {
        long id = this.counter.getAndIncrement();
        this.counter.compareAndSet(Long.MAX_VALUE, Long.MIN_VALUE);
        FilesystemCacheReference previous = (FilesystemCacheReference)((Object)this.fileid.put((Object)id, (Object)new FilesystemCacheReference(file)));
        if (null != previous) {
            log.error(String.format("Previous reference for id %s was not null but %s", new Object[]{id, previous}));
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Set file id %s for path %s", id, file));
        }
        return id;
    }

    @Override
    public synchronized Long get(Path file) throws NotfoundException {
        Long key = (Long)this.fileid.getKey((Object)new FilesystemCacheReference(file));
        if (key == null) {
            throw new NotfoundException(String.format("No simple mapping for file %s", file.getAbsolute()));
        }
        return key;
    }

    @Override
    public synchronized Path reverse(Long fileId) throws NotfoundException {
        FilesystemCacheReference reference = (FilesystemCacheReference)((Object)this.fileid.get((Object)fileId));
        if (null == reference) {
            throw new NotfoundException(fileId.toString());
        }
        Path file = reference.getFile();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Return path %s for file %s", file, fileId));
        }
        return file;
    }

    @Override
    public synchronized Long swap(Path file, Path destination) throws NotfoundException {
        Long id = (Long)this.fileid.getKey((Object)new FilesystemCacheReference(file));
        if (null == id) {
            throw new NotfoundException(file.getAbsolute());
        }
        this.fileid.replace((Object)id, (Object)new FilesystemCacheReference(destination));
        if (file.isDirectory()) {
            this.fileid.values().removeIf(reference -> reference.getFile().isChild(file));
        }
        return id;
    }

    @Override
    public void clear() {
        this.fileid.clear();
        this.counter.set(Long.MAX_VALUE);
    }

    @Override
    public Long remove(Path file) {
        Long value = (Long)this.fileid.removeValue((Object)new FilesystemCacheReference(file));
        if (null == value) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Removed id %s for path %s", value, file));
        }
        return value;
    }

    @Override
    public int size() {
        return this.fileid.size();
    }
}

