/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalCacheDirectoryGenerations
implements FilesystemDirectoryGenerations {
    private static final Logger log = LogManager.getLogger((String)LocalCacheDirectoryGenerations.class.getName());
    private final LocalCache<?> cache;

    public LocalCacheDirectoryGenerations(LocalCache<?> cache) {
        this.cache = cache;
    }

    @Override
    public Long get(Path directory) {
        return this.cache.toLocal(directory).attributes().getModificationDate();
    }

    @Override
    public Long increment(Path directory) {
        long timestamp = System.nanoTime();
        Local local = this.cache.toLocal(directory);
        try {
            local.attributes().setModificationDate(timestamp);
        }
        catch (AccessDeniedException e) {
            log.warn(String.format("Failure updating timestamp for directory %s", local));
        }
        return timestamp;
    }

    @Override
    public void clear() {
    }

    @Override
    public void remove(Path directory) {
    }
}

