/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KeepAliveSessionPool
implements FilesystemSessionPool {
    private static final Logger log = LogManager.getLogger((String)KeepAliveSessionPool.class.getName());
    private final FilesystemSessionPool proxy;

    public KeepAliveSessionPool(FilesystemSessionPool proxy) {
        this.proxy = proxy;
    }

    public void release(Session<?> session, BackgroundException failure) {
        Protocol.Type protocol = session.getHost().getProtocol().getType();
        switch (protocol) {
            case irods: 
            case ftp: {
                if (null == failure) {
                    log.debug(String.format("Keep alive session %s", session));
                    break;
                }
            }
            default: {
                this.proxy.release(session, failure);
            }
        }
    }

    public void evict() {
        this.proxy.evict();
    }

    public Host getHost() {
        return this.proxy.getHost();
    }

    public VaultRegistry getVault() {
        return this.proxy.getVault();
    }

    public Session.State getState() {
        return this.proxy.getState();
    }

    public <T> T getFeature(Class<T> aClass) {
        return (T)this.proxy.getFeature(aClass);
    }

    public void shutdown() {
        this.proxy.shutdown();
    }

    public Session<?> borrow(BackgroundActionState state) throws BackgroundException {
        return this.proxy.borrow(state);
    }

    @Override
    public Session<?> borrow() throws BackgroundException {
        return this.proxy.borrow();
    }

    @Override
    public void release(Session<?> session) {
        this.proxy.release(session);
    }

    @Override
    public <T> T await(Worker<T> worker, FilesystemSessionPool pool) throws BackgroundException {
        return this.proxy.await(worker, pool);
    }

    @Override
    public <T> Future<T> execute(Worker<T> worker) throws BackgroundException {
        return this.proxy.execute(worker);
    }
}

