/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemWriters;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class InternalListProgressListener
extends IndexedListProgressListener {
    private static final Logger log = LogManager.getLogger((String)InternalListProgressListener.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final FilesystemWriters writers;
    private final ListProgressListener listener;
    private final Integer retain;
    private final FilesystemListFilter filter;

    public InternalListProgressListener(FilesystemOperations<?> fs, FilesystemWriters writers, ListProgressListener listener, FilesystemListFilter filter) {
        this(writers, listener, 5, filter);
    }

    public InternalListProgressListener(FilesystemWriters writers, ListProgressListener listener, Integer retain, FilesystemListFilter filter) {
        this.writers = writers;
        this.listener = listener;
        this.retain = retain;
        this.filter = filter;
    }

    public void chunk(Path folder, AttributedList<Path> list) throws ConnectionCanceledException {
        super.chunk(folder, list);
        if (list.size() < this.retain) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Delay chunk notification for file listing of folder %s", folder));
            }
        } else {
            this.listener.chunk(folder, list);
        }
    }

    public void visit(AttributedList<Path> list, int index, Path file) {
        if (!this.filter.accept(file)) {
            list.remove(index);
        } else {
            if (file.isSymbolicLink() && !this.preferences.getBoolean("fs.symlink.enable")) {
                file.setAttributes(new PathAttributes(file.getSymlinkTarget().attributes()));
            }
            for (FilesystemCacheReference internal : this.writers.keySet()) {
                if (!Objects.equals((Object)new FilesystemCacheReference(file), (Object)internal)) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Remove entry %s with attributes %s from server directory listing and replace with %s", new Object[]{file, file.attributes(), internal}));
                }
                list.set(index, (Referenceable)internal.getFile());
            }
        }
    }

    public void message(String message) {
        this.listener.message(message);
    }
}

