/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCache;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InodeFilesystemPathCache<Inode>
implements FilesystemCache {
    private static final Logger log = LogManager.getLogger((String)InodeFilesystemPathCache.class.getName());
    private final FilesystemCache proxy;
    private final FileidMapper<Inode> inode;

    public InodeFilesystemPathCache(FilesystemCache proxy, FileidMapper<Inode> inode) {
        this.inode = inode;
        this.proxy = proxy;
    }

    @Override
    public Path swap(Path previous, Path updated) {
        try {
            this.inode.swap(previous, updated);
        }
        catch (NotfoundException e) {
            log.warn(String.format("Ignore failure finding file %s in inode cache", previous));
        }
        return this.proxy.swap(previous, updated);
    }

    public AttributedList<Path> remove(Path directory) {
        AttributedList previous = this.proxy.remove((Referenceable)directory);
        for (Path f : previous) {
            this.inode.remove(f);
        }
        return previous;
    }

    @Override
    public void lock(Object sender) {
        this.proxy.lock(sender);
    }

    @Override
    public void unlock(Object sender) {
        this.proxy.unlock(sender);
    }

    @Override
    public void delete(Path file) {
        this.proxy.delete(file);
    }

    @Override
    public void add(Object sender, Path file) {
        this.proxy.add(sender, file);
    }

    public CacheReference<?> reference(Path object) {
        return this.proxy.reference((Referenceable)object);
    }

    public boolean isCached(Path parent) {
        return this.proxy.isCached((Referenceable)parent);
    }

    public long size() {
        return this.proxy.size();
    }

    public boolean isEmpty() {
        return this.proxy.isEmpty();
    }

    public boolean isValid(Path item) {
        return this.proxy.isValid((Referenceable)item);
    }

    public AttributedList<Path> put(Path parent, AttributedList<Path> children) {
        return this.proxy.put((Referenceable)parent, children);
    }

    public AttributedList<Path> get(Path parent) {
        return this.proxy.get((Referenceable)parent);
    }

    public Map<Path, AttributedList<Path>> asMap() {
        return this.proxy.asMap();
    }

    public void invalidate(Path parent) {
        this.proxy.invalidate((Referenceable)parent);
    }

    public void clear() {
        this.proxy.clear();
    }

    public Path lookup(CacheReference<Path> reference) {
        return (Path)this.proxy.lookup(reference);
    }
}

