/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.PathFilenameComposer;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class InodeFilenameComposer<Inode>
implements PathFilenameComposer {
    private final FileidMapper<Inode> fileid;

    public InodeFilenameComposer(FileidMapper<Inode> fileid) {
        this.fileid = fileid;
    }

    @Override
    public Path compose(Path workdir, String filename, EnumSet<AbstractPath.Type> type) {
        if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)filename)) {
            return workdir;
        }
        try {
            Inode inode = this.fileid.get(this.compose(workdir, PathNormalizer.parent((String)filename, (char)'/'), EnumSet.of(AbstractPath.Type.directory)));
            Path f = new Path(this.fileid.reverse(inode), PathNormalizer.name((String)filename), type);
            try {
                return this.fileid.reverse(this.fileid.get(f));
            }
            catch (NotfoundException e) {
                return f;
            }
        }
        catch (NotfoundException e) {
            Path parent = this.compose(workdir, PathNormalizer.parent((String)filename, (char)'/'), EnumSet.of(AbstractPath.Type.directory));
            return new Path(parent, PathNormalizer.name((String)filename), type);
        }
    }
}

