/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemUnmountWorker
extends Worker<Boolean> {
    private static final Logger log = LogManager.getLogger((String)FilesystemUnmountWorker.class.getName());
    private final FilesystemMountRegistry registry;
    private final Filesystem fs;

    public FilesystemUnmountWorker(Filesystem fs) {
        this(fs, FilesystemMountRegistry.get());
    }

    public FilesystemUnmountWorker(Filesystem fs, FilesystemMountRegistry registry) {
        this.registry = registry;
        this.fs = fs;
    }

    public Boolean initialize() {
        return false;
    }

    public Boolean run(Session nil) throws BackgroundException {
        try {
            this.fs.unmount();
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Ignore unmount failure %s", new Object[]{e}));
            return false;
        }
        return true;
    }

    public void cleanup(Boolean result) {
        this.registry.disconnected(this.fs);
    }

    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString((String)"Disconnecting {0}", (String)"Status"), this.fs.getHost().getHostname());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesystemUnmountWorker)) {
            return false;
        }
        FilesystemUnmountWorker that = (FilesystemUnmountWorker)((Object)o);
        return Objects.equals(this.fs, that.fs);
    }

    public int hashCode() {
        return Objects.hash(this.fs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemUnmountWorker{");
        sb.append("fs=").append(this.fs);
        sb.append('}');
        return sb.toString();
    }
}

