/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.BackgroundActionListener;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemUnmountWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemUnmountBackgroundAction
extends WorkerBackgroundAction<Boolean> {
    private static final Logger log = LogManager.getLogger((String)FilesystemUnmountBackgroundAction.class.getName());
    private final Filesystem fs;
    private final Callback callback;

    public FilesystemUnmountBackgroundAction(Controller controller, Filesystem fs, Callback callback) {
        super((BackgroundActionListener)controller, SessionPool.DISCONNECTED, (Worker)new FilesystemUnmountWorker(fs), (ProgressListener)controller, (AlertCallback)new DisabledAlertCallback());
        this.fs = fs;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean run() throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Obtain lock for %s", this.fs));
        }
        Filesystem filesystem = this.fs;
        synchronized (filesystem) {
            return (Boolean)this.run(null);
        }
    }

    public void cleanup() {
        try {
            super.cleanup();
        }
        finally {
            this.callback.done(this.fs);
        }
    }

    public static interface Callback {
        public void done(Filesystem var1);
    }
}

