/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.LockPatternService;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemUnlockWorker
extends Worker<String> {
    private static final Logger log = LogManager.getLogger((String)FilesystemUnlockWorker.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final LockPatternService patterns;
    private final FilesystemCallbacks<?> fs;
    private final Set<FilesystemCacheReference> owners;
    private final Path file;
    private final String lockId;

    public FilesystemUnlockWorker(FilesystemCallbacks<?> fs, Set<FilesystemCacheReference> owners, Path file, String lockId) {
        this(LockPatternService.standard, fs, owners, file, lockId);
    }

    public FilesystemUnlockWorker(LockPatternService patterns, FilesystemCallbacks<?> fs, Set<FilesystemCacheReference> owners, Path file, String lockId) {
        this.patterns = patterns;
        this.fs = fs;
        this.owners = owners;
        this.file = file;
        this.lockId = lockId;
    }

    public String run(Session<?> session) throws BackgroundException {
        if (!this.preferences.getBoolean("fs.lock.enable")) {
            return null;
        }
        Lock feature = (Lock)session.getFeature(Lock.class);
        if (null == feature) {
            return this.unlock(session, this.patterns);
        }
        try {
            feature.unlock(this.file, (Object)this.lockId);
            return this.lockId;
        }
        catch (BackgroundException e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Exception during unlock %s", e.getMessage()));
            }
            return null;
        }
    }

    protected String unlock(Session<?> session, LockPatternService patterns) throws BackgroundException {
        Set<Path> locks = patterns.derive(this.file);
        for (Path lock : locks) {
            if (this.owners.contains((Object)new FilesystemCacheReference(lock))) {
                log.warn(String.format("Skip looking for lock owner file %s on server created previously", lock));
                continue;
            }
            try {
                this.fs.find(lock.getParent(), lock.getName(), FilesystemCallbacks.Flags.offline);
                log.warn(String.format("Skip unlock for %s with matching lock owner file %s", this.file, lock));
                return null;
            }
            catch (NotfoundException e) {
                return this.lockId;
            }
        }
        return this.lockId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FilesystemUnlockWorker that = (FilesystemUnlockWorker)((Object)o);
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String initialize() {
        return this.lockId;
    }

    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString((String)"Unlock {0}", (String)"Status"), this.file.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemUnlockWorker{");
        sb.append("file=").append(this.file);
        sb.append(", lockId='").append(this.lockId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

