/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.worker.TouchWorker;
import ch.iterate.mountainduck.exception.FileAlreadyExistsException;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemTouchWorker
extends TouchWorker {
    private static final Logger log = LogManager.getLogger((String)FilesystemTouchWorker.class.getName());
    private final FilesystemOperations<?> fs;
    private final FilesystemBuffers buffers;
    private final FilesystemCache cache;
    private final Path file;
    private final FilesystemFilenameBlacklist blacklist;
    private final FilesystemFilenameBlacklist owner;
    private final Preferences preferences = PreferencesFactory.get();

    public FilesystemTouchWorker(FilesystemOperations<?> fs, FilesystemBuffers buffers, FilesystemCache cache, Path file, FilesystemFilenameBlacklist blacklist, FilesystemFilenameBlacklist owner) {
        super(file);
        this.fs = fs;
        this.buffers = buffers;
        this.cache = cache;
        this.file = file;
        this.blacklist = blacklist;
        this.owner = owner;
    }

    public Path run(Session<?> session) throws BackgroundException {
        try {
            Path target;
            CachingFindFeature finder = new CachingFindFeature((Cache)this.cache, (Find)new DefaultFindFeature(session));
            if (finder.find(this.file) && !new TemporaryFileMarker().contains(this.file)) {
                throw new FileAlreadyExistsException(this.file.getAbsolute());
            }
            if (this.isSupported(session, this.file)) {
                target = super.run(session);
                this.fs.open(target, FilesystemCallbacks.Mode.write_truncate, 0L, Application.notfound);
            } else {
                Vault vault = this.fs.getVault().find(session, this.file);
                target = new TemporaryFileMarker().set(vault.decrypt(session, vault.encrypt(session, this.file)));
                this.buffers.getOrCreate(target);
            }
            return this.cache(target);
        }
        catch (NotfoundException e) {
            throw new AccessDeniedException(e.getDetail(), (Throwable)e);
        }
    }

    private boolean isSupported(Session<?> session, Path file) {
        if (!((Touch)session.getFeature(Touch.class)).isSupported(file.getParent(), file.getName())) {
            log.warn(String.format("Filename %s not supported", file.getName()));
            return false;
        }
        if (this.owner.contains(file)) {
            return true;
        }
        return this.preferences.getBoolean("fs.touch.enable") && !this.blacklist.contains(file);
    }

    protected String getLockId(Path file) {
        return this.fs.getLock(file);
    }

    protected Path cache(Path target) {
        long time = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update creation date in attributes for %s to %d", target, time));
        }
        target.attributes().setAccessedDate(time);
        target.attributes().setCreationDate(time);
        target.attributes().setModificationDate(time);
        target.attributes().setSize(0L);
        this.cache.add((Object)this, target);
        return target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemTouchWorker{");
        sb.append("fs=").append(this.fs);
        sb.append(", cache=").append(this.cache);
        sb.append(", file=").append(this.file);
        sb.append(", blacklist=").append(this.blacklist);
        sb.append('}');
        return sb.toString();
    }
}

