/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.worker.WriteTimestampWorker;
import ch.iterate.mountainduck.fs.FilesystemOperations;

public class FilesystemTimestampWorker
extends WriteTimestampWorker {
    private final FilesystemOperations<?> fs;

    public FilesystemTimestampWorker(FilesystemOperations<?> fs, Path file, Long timestamp) {
        super(file, timestamp);
        this.fs = fs;
    }

    public Boolean run(Session<?> session) throws BackgroundException {
        Timestamp feature = (Timestamp)session.getFeature(Timestamp.class);
        if (null == feature) {
            throw new UnsupportedException(String.format("%s feature not supported for %s", Timestamp.class.getName(), session.getHost().getProtocol()));
        }
        try {
            if (super.run(session).booleanValue()) {
                return true;
            }
            throw new UnsupportedException(String.format("%s feature not supported for %s", UnixPermission.class.getName(), session.getHost().getProtocol()));
        }
        catch (BackgroundException e) {
            throw new UnsupportedException((Throwable)e);
        }
    }

    protected String getLockId(Path file) {
        return this.fs.getLock(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemTimestampWorker{");
        sb.append("fs=").append(this.fs);
        sb.append('}');
        return sb.toString();
    }
}

