/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.worker.CreateSymlinkWorker;
import ch.iterate.mountainduck.fs.FilesystemCache;

public class FilesystemSymlinkWorker
extends CreateSymlinkWorker {
    private final FilesystemCache cache;
    private final Path target;

    public FilesystemSymlinkWorker(FilesystemCache cache, Path file, Path target) {
        super(file, target.getAbsolute());
        this.cache = cache;
        this.target = target;
    }

    public Path run(Session<?> session) throws BackgroundException {
        Symlink feature = (Symlink)session.getFeature(Symlink.class);
        if (null == feature) {
            throw new UnsupportedException(String.format("%s feature not supported for %s", Symlink.class.getName(), session.getHost().getProtocol()));
        }
        return super.run(session);
    }

    public void cleanup(Path file) {
        file.setSymlinkTarget(this.target);
        this.cache.add((Object)this, file);
        super.cleanup((Object)file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemSymlinkWorker{");
        sb.append("target=").append(this.target);
        sb.append('}');
        return sb.toString();
    }
}

