/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemQuotaWorker
extends Worker<Quota.Space> {
    private static final Logger log = LogManager.getLogger((String)FilesystemQuotaWorker.class.getName());
    private final Controller controller;
    private final FilesystemOperations<?> operations;

    public FilesystemQuotaWorker(Controller controller, FilesystemOperations<?> operations) {
        this.controller = controller;
        this.operations = operations;
    }

    public Quota.Space run(Session<?> session) {
        if (new HostPreferences(session.getHost()).getBoolean("fs.quota.enable")) {
            try {
                Quota.Space space = this.read(session);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Determined quota %s", space));
                }
                this.alert(space);
                return space;
            }
            catch (UnsupportedException unsupportedException) {
                // empty catch block
            }
        }
        return FilesystemOperations.QUOTA_UNKNOWN;
    }

    private void alert(Quota.Space space) {
        if (space.available <= new HostPreferences(this.operations.getHost()).getLong("fs.quota.warning.bytes")) {
            log.warn(String.format("Notify with soft quota warning for available space %s", space));
            NotificationServiceFactory.get().notify(BookmarkNameProvider.toString((Host)this.operations.getHost()), StringUtils.isNotBlank((CharSequence)new HostPreferences(this.operations.getHost()).getProperty("quota.notification.url")) ? new HostPreferences(this.operations.getHost()).getProperty("quota.notification.url") : new DefaultProviderHelpService().help(this.operations.getHost().getProtocol()), LocaleFactory.localizedString((String)"Insufficient disk space", (String)"Error"), MessageFormat.format(LocaleFactory.localizedString((String)"Only {0} available disk space", (String)"Error"), SizeFormatterFactory.get().format(space.available.longValue())), LocaleFactory.localizedString((String)"Help", (String)"Main"));
        }
    }

    private Quota.Space read(Session<?> session) throws UnsupportedException {
        switch (session.getHost().getProtocol().getType()) {
            case swift: {
                throw new UnsupportedException(String.format("%s feature not supported for %s", Quota.class.getName(), session.getHost().getProtocol()));
            }
        }
        Quota feature = (Quota)session.getFeature(Quota.class);
        if (null == feature) {
            throw new UnsupportedException(String.format("%s feature not supported for %s", Quota.class.getName(), session.getHost().getProtocol()));
        }
        try {
            Quota.Space quota = feature.get();
            if (quota.available < 0L) {
                log.warn(String.format("Bogus available quota %d in server response", quota.available));
                return new Quota.Space(quota.used, FilesystemOperations.QUOTA_UNKNOWN.available);
            }
            return quota;
        }
        catch (BackgroundException e) {
            log.warn(String.format("Ignore failure to determine quota. %s", e.getMessage()));
            throw new UnsupportedException((Throwable)e);
        }
    }
}

