/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WritePermissionWorker;
import java.util.Collections;

public class FilesystemPermissionWorker
extends WritePermissionWorker {
    public FilesystemPermissionWorker(Path file, Permission permission) {
        super(Collections.singletonList(file), permission, (Worker.RecursiveCallback)new BooleanRecursiveCallback(false), (ProgressListener)new DisabledProgressListener());
    }

    public Boolean run(Session<?> session) throws BackgroundException {
        UnixPermission feature = (UnixPermission)session.getFeature(UnixPermission.class);
        if (null == feature) {
            throw new UnsupportedException(String.format("%s feature not supported for %s", UnixPermission.class.getName(), session.getHost().getProtocol()));
        }
        try {
            if (super.run(session).booleanValue()) {
                return true;
            }
            throw new UnsupportedException(String.format("%s feature not supported for %s", UnixPermission.class.getName(), session.getHost().getProtocol()));
        }
        catch (BackgroundException e) {
            throw new UnsupportedException((Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemPermissionWorker{");
        sb.append('}');
        return sb.toString();
    }
}

