/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.iterate.mountainduck.fs.FilenameMatchPathPredicate;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemReaders;
import ch.iterate.mountainduck.fs.FilesystemWriters;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemPathCache
extends PathCache
implements FilesystemCache {
    private static final Logger log = LogManager.getLogger((String)FilesystemPathCache.class.getName());
    private final FilesystemWriters writers;
    private final FilesystemReaders readers;
    private final FilesystemBuffers buffers;
    private final FilesystemDirectoryGenerations timestamps;
    private final ReentrantLock lock = new ReentrantLock();

    public FilesystemPathCache(FilesystemBuffers buffers, FilesystemWriters writers, FilesystemReaders readers, FilesystemDirectoryGenerations timestamps) {
        this(buffers, writers, readers, timestamps, Integer.MAX_VALUE);
    }

    public FilesystemPathCache(FilesystemBuffers buffers, FilesystemWriters writers, FilesystemReaders readers, FilesystemDirectoryGenerations timestamps, int size) {
        super(size);
        this.buffers = buffers;
        this.writers = writers;
        this.readers = readers;
        this.timestamps = timestamps;
    }

    @Override
    public void lock(Object sender) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Aquire lock for %s", sender));
        }
        if (!this.lock.isHeldByCurrentThread()) {
            this.lock.lock();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Lock aquired for %s", sender));
        }
    }

    @Override
    public void unlock(Object sender) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Release lock for %s", sender));
        }
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributedList<Path> put(Path directory, AttributedList<Path> children) {
        this.lock(this);
        try {
            AttributedList previous = super.put((Referenceable)directory, children);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Override cache for %s", directory));
            }
            if (null != previous) {
                for (Path f : previous) {
                    if (new TemporaryFileMarker().contains(f) || !f.isFile()) continue;
                    if (this.writers.containsKey((Object)new FilesystemCacheReference(f))) {
                        log.warn(String.format("Skip closing buffer for file %s with open writer", f));
                        continue;
                    }
                    if (this.readers.containsKey((Object)new FilesystemCacheReference(f))) {
                        log.warn(String.format("Skip closing buffer for file %s with open reader", f));
                        continue;
                    }
                    this.buffers.remove(f).close();
                }
            }
            AttributedList attributedList = previous;
            return attributedList;
        }
        finally {
            this.unlock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributedList<Path> remove(Path directory) {
        this.lock(this);
        try {
            AttributedList list = super.remove((Referenceable)directory);
            for (Path f : list) {
                if (new TemporaryFileMarker().contains(f)) continue;
                this.buffers.remove(f).close();
            }
            this.timestamps.remove(directory);
            Iterator iterator = list;
            return iterator;
        }
        finally {
            this.unlock(this);
        }
    }

    @Override
    public void delete(Path changed) {
        if (null == changed) {
            this.delete(Collections.emptyList());
        } else {
            this.delete(Collections.singletonList(changed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(List<Path> files) {
        this.lock(this);
        try {
            for (Path f : files) {
                Path directory = f.getParent();
                if (this.isCached((Referenceable)directory)) {
                    AttributedList list = this.get((Referenceable)directory);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Modify cache for %s removing %s with attributes %s", directory, f, f.attributes()));
                    }
                    if (!list.remove((Referenceable)f)) {
                        log.warn(String.format("Failure to remove file %s from cache", f));
                    }
                }
                this.timestamps.increment(directory);
                if (f.isDirectory()) {
                    this.remove(f);
                }
                this.buffers.remove(f).close();
            }
        }
        finally {
            this.unlock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object sender, Path file) {
        this.lock(this);
        try {
            Path directory = file.getParent();
            if (this.isCached((Referenceable)directory)) {
                AttributedList list;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Modify cache for %s adding %s with attributes %s", directory, file, file.attributes()));
                }
                if ((list = this.get((Referenceable)directory)).isEmpty()) {
                    list = new AttributedList();
                }
                if (list.remove((Referenceable)file)) {
                    log.warn(String.format("Removed previous cache entry %s", file));
                }
                list.add((Referenceable)file);
                this.put(directory, (AttributedList<Path>)list);
            } else {
                this.put(directory, (AttributedList<Path>)new AttributedList(Collections.singletonList(file)));
            }
        }
        finally {
            this.unlock(this);
        }
    }

    public void clear() {
        this.timestamps.clear();
        super.clear();
    }

    public void invalidate(Path directory) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update generation id for directory %s", directory));
        }
        this.timestamps.increment(directory);
        super.invalidate((Referenceable)directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path swap(Path previous, Path updated) {
        this.lock(this);
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Swap cache for %s with %s", previous, updated));
            }
            MarkerBuffer buffer = this.buffers.remove(previous);
            if (!new FilenameMatchPathPredicate(previous).test(updated)) {
                this.delete(previous);
            }
            AttributedList paths = this.get((Referenceable)updated.getParent());
            if (!new FilenameMatchPathPredicate(previous).test(updated)) {
                this.delete((Path)paths.find((Predicate)((Object)new FilenameMatchPathPredicate(updated))));
            }
            if (AttributedList.EMPTY == paths && new SimplePathPredicate(previous).test(updated)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Skip adding %s due to missing parent in cache", updated));
                }
            } else {
                this.add(this, updated);
            }
            switch (buffer.getState()) {
                case open: {
                    if (buffer.length().longValue() != updated.attributes().getSize()) {
                        buffer.close();
                        buffer.truncate(updated.attributes().getSize());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Set buffer %s for %s", buffer, updated));
                    }
                    this.buffers.put(updated, buffer);
                }
            }
            Path path = updated;
            return path;
        }
        finally {
            this.unlock(this);
        }
    }
}

