/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.worker.MoveWorker;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemWriters;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferedWriteStrategy;
import ch.iterate.mountainduck.io.DelegatingWriteStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemMoveWorker
extends MoveWorker {
    private static final Logger log = LogManager.getLogger((String)FilesystemMoveWorker.class.getName());
    private final Controller controller;
    private final SessionFilesystemOperations<?> fs;
    private final FilesystemBuffers buffers;
    private final FilesystemWriters writers;
    private final FilesystemCache cache;
    private final Path file;
    private final Path target;

    public FilesystemMoveWorker(Controller controller, SessionFilesystemOperations<?> fs, FilesystemBuffers buffers, FilesystemWriters writers, FilesystemCache cache, Path file, Path target) {
        super(Collections.singletonMap(file, target), (SessionPool)(fs.getHost().getProtocol().getStatefulness() == Protocol.Statefulness.stateful ? SessionPoolFactory.create((Controller)controller, (Host)fs.getHost()) : fs.getPool()), (Cache)(FilesystemFilenameBlacklist.skipmove.contains(target) || new TemporaryFileMarker().contains(target) ? FilesystemCache.empty() : cache), (ProgressListener)controller, (ConnectionCallback)LoginCallbackFactory.get((Controller)controller));
        this.controller = controller;
        this.fs = fs;
        this.buffers = buffers;
        this.writers = writers;
        this.cache = cache;
        this.file = file;
        this.target = target;
    }

    protected String getLockId(Path file) {
        return this.fs.getLock(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Path, Path> run(Session<?> session) throws BackgroundException {
        if (this.file.isFile()) {
            if (new TemporaryFileMarker().contains(this.file)) {
                if (FilesystemFilenameBlacklist.temporary.contains(this.target)) {
                    new TemporaryFileMarker().set(this.target);
                    this.buffers.put(this.target, this.buffers.get(this.file));
                    new TemporaryFileMarker().remove(this.file);
                    this.buffers.remove(this.file);
                } else {
                    MarkerBuffer buffer = this.buffers.get(this.file);
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Upload previous temporary file %s with buffer %s to %s", this.file, buffer, this.target));
                    }
                    this.target.attributes().setCustom(new HashMap(this.file.attributes().getCustom()));
                    this.target.attributes().setModificationDate(this.file.attributes().getModificationDate());
                    this.target.attributes().setPermission(this.file.attributes().getPermission() == Permission.EMPTY ? Permission.EMPTY : new Permission(this.file.attributes().getPermission()));
                    this.target.attributes().setAcl(this.file.attributes().getAcl() == Acl.EMPTY ? Acl.EMPTY : new Acl(this.file.attributes().getAcl()));
                    DelegatingWriteStrategy writer = new DelegatingWriteStrategy(this.fs, FilesystemFilenameBlacklist.skipmove.contains(this.target) ? FilesystemCache.empty() : this.cache, FilesystemCallbacks.Mode.write_truncate, buffer, new BufferedWriteStrategy(this.fs, FilesystemFilenameBlacklist.skipmove.contains(this.target) ? FilesystemCache.empty() : this.cache, buffer, (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller)), (ConnectionCallback)LoginCallbackFactory.get((Controller)this.controller), FilesystemFilenameBlacklist.temporary);
                    this.writers.put(new FilesystemCacheReference(this.target), writer);
                    try {
                        writer.close(this.target);
                    }
                    finally {
                        this.writers.remove((Object)new FilesystemCacheReference(this.target));
                    }
                }
                Vault vault = this.fs.getVault().find(session, this.target);
                return Collections.singletonMap(this.file, vault.decrypt(session, vault.encrypt(session, this.target, this.target.isDirectory())));
            }
            if (FilesystemFilenameBlacklist.skipmove.contains(this.file) && FilesystemFilenameBlacklist.temporary.contains(this.target)) {
                return Collections.singletonMap(this.file, this.target);
            }
        }
        Map result = super.run(session);
        if (this.file.isDirectory()) {
            for (Path f : this.buffers.find(this.file)) {
                if (!new TemporaryFileMarker().contains(f)) continue;
                result.put(f, new Path(this.target, f.getName(), f.getType(), f.attributes()));
            }
        }
        return result;
    }

    public void cleanup(Map<Path, Path> result) {
        for (Map.Entry entry : result.entrySet().stream().sorted(new Comparator<Map.Entry<Path, Path>>(){

            @Override
            public int compare(Map.Entry<Path, Path> o1, Map.Entry<Path, Path> o2) {
                if (o1.getKey().isChild(o2.getKey())) {
                    return 1;
                }
                if (o2.getKey().isChild(o1.getKey())) {
                    return -1;
                }
                return 0;
            }
        }).collect(Collectors.toList())) {
            Path source = (Path)entry.getKey();
            Path target = (Path)entry.getValue();
            target.attributes().setSize(source.attributes().getSize());
            target.attributes().setAcl(new Acl(source.attributes().getAcl()));
            target.attributes().setPermission(this.file.attributes().getPermission() == Permission.EMPTY ? Permission.EMPTY : new Permission(this.file.attributes().getPermission()));
            target.attributes().setChecksum(new Checksum(source.attributes().getChecksum()));
            target.attributes().setMetadata(new HashMap(source.attributes().getMetadata()));
            target.attributes().setAccessedDate(source.attributes().getAccessedDate());
            target.attributes().setModificationDate(source.attributes().getModificationDate());
            this.cache.swap(source, target);
        }
        super.cleanup(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemMoveWorker{");
        sb.append("fs=").append(this.fs);
        sb.append(", file=").append(this.file);
        sb.append(", target=").append(this.target);
        sb.append('}');
        return sb.toString();
    }
}

