/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.shared.DefaultPathHomeFeature;
import ch.cyberduck.core.shared.DelegatingHomeFeature;
import ch.cyberduck.core.shared.PathAttributesHomeFeature;
import ch.cyberduck.core.shared.WorkdirHomeFeature;
import ch.cyberduck.core.worker.MountWorker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.text.MessageFormat;
import java.util.Objects;

public class FilesystemMountWorker
extends MountWorker {
    private final Filesystem fs;
    private final FilesystemMountRegistry registry;
    private final RevealService reveal;
    private final Host bookmark;
    private Filesystem.Options options = Filesystem.Options.readwrite;

    public FilesystemMountWorker(Filesystem fs, RevealService reveal, FilesystemMountRegistry registry, ListProgressListener listener) {
        super(fs.getHost(), (Cache)fs.getCache(), listener);
        this.fs = fs;
        this.reveal = reveal;
        this.registry = registry;
        this.bookmark = fs.getHost();
    }

    public FilesystemMountWorker withOptions(Filesystem.Options options) {
        this.options = options;
        return this;
    }

    public Path run(Session<?> session) throws BackgroundException {
        Path workdir = null == session ? new DelegatingHomeFeature(new Home[]{new DefaultPathHomeFeature(this.fs.getHost()), new WorkdirHomeFeature(this.fs.getHost())}).find() : this.list(session, (Home)new PathAttributesHomeFeature(session, (Home)new DelegatingHomeFeature(new Home[]{new DefaultPathHomeFeature(session.getHost()), (Home)session.getFeature(Home.class)}), (AttributesFinder)session.getFeature(AttributesFinder.class), (PathContainerService)session.getFeature(PathContainerService.class)));
        this.fs.mount(workdir, this.options);
        this.reveal.reveal(this.fs.getMountpoint());
        return workdir;
    }

    public void cleanup(Path workdir) {
        if (null == workdir) {
            this.registry.disconnected(this.fs);
        } else {
            this.bookmark.setWorkdir(workdir);
            this.registry.connected(this.fs);
        }
        super.cleanup(workdir);
    }

    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString((String)"Opening {0} connection to {1}", (String)"Status"), this.bookmark.getProtocol().getName(), this.bookmark.getHostname());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesystemMountWorker)) {
            return false;
        }
        FilesystemMountWorker that = (FilesystemMountWorker)((Object)o);
        return Objects.equals(this.fs, that.fs);
    }

    public int hashCode() {
        return Objects.hash(this.fs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemMountWorker{");
        sb.append("fs=").append(this.fs);
        sb.append(", bookmark=").append(this.bookmark);
        sb.append('}');
        return sb.toString();
    }
}

