/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.VolumeService;
import ch.iterate.mountainduck.fs.VolumeServiceFactory;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FilesystemMountRegistry {
    private static final Logger log = LogManager.getLogger((String)FilesystemMountRegistry.class.getName());
    private static FilesystemMountRegistry singleton;
    private final Map<Host, Filesystem> internal = new ConcurrentHashMap<Host, Filesystem>();
    private final Map<Filesystem, Set<Local>> failed = new ConcurrentHashMap<Filesystem, Set<Local>>();
    private final VolumeService volumes;
    private final Set<Listener> listeners = new HashSet<Listener>();
    private final Preferences preferences = PreferencesFactory.get();

    public static FilesystemMountRegistry get() {
        if (null == singleton) {
            singleton = new FilesystemMountRegistry(VolumeServiceFactory.get());
        }
        return singleton;
    }

    public FilesystemMountRegistry(VolumeService volumes) {
        this.volumes = volumes;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public Local register(Filesystem fs) {
        Filesystem previous;
        if (log.isInfoEnabled()) {
            log.info(String.format("Mount bookmark %s on %s", fs.getHost(), fs.getMountpoint()));
        }
        if ((previous = this.internal.remove(fs.getHost())) != null) {
            Local mountpoint = previous.getMountpoint();
            if (mountpoint != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add %s to temporary list of failed volumes", mountpoint));
                }
                if (this.failed.containsKey(fs)) {
                    this.failed.get(fs).add(mountpoint);
                }
            }
        } else {
            this.failed.put(fs, new HashSet());
        }
        this.internal.put(fs.getHost(), fs);
        return this.volumes.borrow(fs.getHost());
    }

    public void connected(Filesystem fs) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Connected filesystem %s", fs));
        }
        this.cleanup(fs);
        for (Listener listener : this.listeners.toArray(new Listener[this.listeners.size()])) {
            if (listener == null) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Notify listener %s", listener));
            }
            listener.mounted(fs);
        }
    }

    public void disconnected(Filesystem fs) {
        this.remove(fs);
        for (Listener listener : this.listeners.toArray(new Listener[this.listeners.size()])) {
            if (listener == null) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Notify listener %s", listener));
            }
            listener.unmounted(fs);
        }
    }

    private void cleanup(Filesystem fs) {
        Set<Local> mountpoints = this.failed.get(fs);
        if (mountpoints != null) {
            for (Local mount : mountpoints) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Release temporary failed mount point %s", mount));
                }
                this.volumes.release(mount);
            }
            mountpoints.clear();
        }
        this.failed.remove(fs);
    }

    public Filesystem get(Host bookmark) {
        Filesystem fs = this.internal.get(bookmark);
        if (null == fs) {
            log.debug(String.format("No filesystem for bookmark %s", bookmark));
        }
        return fs;
    }

    public Filesystem remove(Filesystem fs) {
        Filesystem removed;
        if (log.isInfoEnabled()) {
            log.info(String.format("Remove bookmark %s", fs));
        }
        if (null == (removed = this.internal.remove(fs.getHost()))) {
            log.warn(String.format("Failed to remove %s from registry", fs));
        }
        this.cleanup(fs);
        if (fs.getMountpoint() != null) {
            this.volumes.release(fs.getMountpoint());
        }
        return fs;
    }

    public void clear() {
        for (Filesystem fs : this.internal.values()) {
            this.remove(fs);
        }
        this.internal.clear();
        this.failed.clear();
    }

    public Set<Filesystem> values() {
        return new HashSet<Filesystem>(this.internal.values());
    }

    public Status getStatus() {
        DirectoryIndexer indexer;
        SyncQueue queue;
        Status status = this.preferences.getBoolean("fs.sync.queue.paused") ? new Status(Status.Sync.paused, LocaleFactory.localizedString((String)"Sync Paused", (String)"Disk")) : new Status(Status.Sync.idle, LocaleFactory.localizedString((String)"In Sync", (String)"Disk"));
        for (Filesystem fs : this.internal.values()) {
            queue = fs.getOperations().getQueue();
            block0 : switch (queue.getStatus()) {
                case paused: 
                case stopped: {
                    status = new Status(Status.Sync.paused, LocaleFactory.localizedString((String)"Sync Paused", (String)"Disk"));
                    break;
                }
                case busy: {
                    status = new Status(Status.Sync.busy, LocaleFactory.localizedString((String)"Sync in Progress", (String)"Disk"));
                    break;
                }
                case idle: {
                    indexer = fs.getOperations().getIndexer();
                    switch (indexer.getStatus()) {
                        case stopped: 
                        case paused: {
                            log.warn(String.format("Ignore paused status of indexer %s", indexer));
                            break block0;
                        }
                        case busy: {
                            status = new Status(Status.Sync.busy, LocaleFactory.localizedString((String)"Indexing", (String)"Disk"));
                        }
                    }
                }
            }
            if (status.sync == Status.Sync.idle) continue;
        }
        for (Filesystem fs : this.internal.values()) {
            queue = fs.getOperations().getQueue();
            status.addStats(queue.stats());
            indexer = fs.getOperations().getIndexer();
            status.addStats(indexer.stats());
            status.addInProgress(fs.getHost(), queue.find(this.preferences.getInteger("fs.sync.queue.peek.size")).stream().map(operation -> new FileHistory.Item(operation.getRemote(), fs.getOperations().getLocalCache().toMount(operation.getRemote()), FileHistory.Item.Origin.fromOperation(operation.getOperation()), operation.getOperation(), operation.getApplication())).collect(Collectors.toList()));
            FileHistory history = fs.getOperations().getHistory();
            status.addHistory(fs.getHost(), history.find(this.preferences.getInteger("fs.sync.history.peek.size")));
        }
        return status;
    }

    public static interface Listener {
        public void mounted(Filesystem var1);

        public void unmounted(Filesystem var1);
    }

    public static final class Status {
        public final Sync sync;
        public final String title;
        public SyncQueue.Stats queue = SyncQueue.Stats.IDLE;
        public DirectoryIndexer.Stats indexer = DirectoryIndexer.Stats.IDLE;
        public final Map<Host, List<FileHistory.Item>> inprogress = new HashMap<Host, List<FileHistory.Item>>();
        public final Map<Host, List<FileHistory.Item>> history = new HashMap<Host, List<FileHistory.Item>>();

        public Status(Sync sync, String title) {
            this.sync = sync;
            this.title = title;
        }

        public void addHistory(Host host, List<FileHistory.Item> history) {
            this.history.put(host, history);
        }

        public void addInProgress(Host host, List<FileHistory.Item> files) {
            this.inprogress.put(host, files);
        }

        public void addStats(SyncQueue.Stats stats) {
            this.queue = this.queue.combine(stats);
        }

        public void addStats(DirectoryIndexer.Stats stats) {
            this.indexer = this.indexer.combine(stats);
        }

        public static enum Sync {
            idle,
            busy,
            paused;

        }
    }
}

