/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.shared.DefaultPathHomeFeature;
import ch.cyberduck.core.shared.DelegatingHomeFeature;
import ch.cyberduck.core.shared.WorkdirHomeFeature;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.fs.FilesystemMountWorker;
import ch.iterate.mountainduck.service.DisabledRevealService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemMountBackgroundAction
extends WorkerBackgroundAction<Path> {
    private static final Logger log = LogManager.getLogger((String)FilesystemMountBackgroundAction.class.getName());
    private final Filesystem fs;

    public FilesystemMountBackgroundAction(Controller controller, Filesystem fs) {
        this(controller, fs, new DisabledRevealService());
    }

    public FilesystemMountBackgroundAction(Controller controller, Filesystem fs, RevealService reveal) {
        this(controller, fs, reveal, FilesystemMountRegistry.get());
    }

    public FilesystemMountBackgroundAction(Controller controller, Filesystem fs, RevealService reveal, FilesystemMountRegistry registry) {
        super(controller, (SessionPool)fs.getPool(), (Worker)new FilesystemMountWorker(fs, reveal, registry, (ListProgressListener)new DisabledListProgressListener()).withOptions(Boolean.TRUE.equals(fs.getHost().getReadonly()) ? Filesystem.Options.readonly : Filesystem.Options.readwrite));
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path run() throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Obtain lock for %s", this.fs));
        }
        Filesystem filesystem = this.fs;
        synchronized (filesystem) {
            switch (this.fs.getMode()) {
                case online: {
                    return (Path)super.run();
                }
            }
            if (ReachabilityFactory.get().isReachable(this.fs.getHost())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Attempt to open connection for %s with reachability check success", this.fs));
                }
                try {
                    return (Path)super.run();
                }
                catch (ConnectionRefusedException | ResolveFailedException e) {
                    log.warn(String.format("Ignore connect failure %s", e));
                }
            }
            Path home = new DelegatingHomeFeature(new Home[]{new DefaultPathHomeFeature(this.fs.getHost()), new WorkdirHomeFeature(this.fs.getHost())}).find();
            switch (this.fs.getStatus(home).getState()) {
                case remote: {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Attempt to open connection for %s with missing cache", this.fs));
                    }
                    return (Path)super.run();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skip opening connection for %s with cache found", this.fs));
            }
            return (Path)super.run(null);
        }
    }
}

