/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.LockPatternService;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemLockWorker
extends Worker<String> {
    private static final Logger log = LogManager.getLogger((String)FilesystemLockWorker.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final LockPatternService patterns;
    private final Set<FilesystemCacheReference> owners;
    private final Path file;

    public FilesystemLockWorker(Set<FilesystemCacheReference> owners, Path file) {
        this(LockPatternService.standard, owners, file);
    }

    public FilesystemLockWorker(LockPatternService patterns, Set<FilesystemCacheReference> owners, Path file) {
        this.patterns = patterns;
        this.owners = owners;
        this.file = file;
    }

    public String run(Session<?> session) throws BackgroundException {
        Lock feature;
        if (!this.preferences.getBoolean("fs.lock.enable")) {
            return null;
        }
        if (this.file.attributes().getLockId() != null) {
            log.warn(String.format("Found lock %s in attributes for %s", this.file.attributes().getLockId(), this.file));
        }
        if (null == (feature = (Lock)session.getFeature(Lock.class))) {
            return this.lock(session, this.patterns);
        }
        return (String)feature.lock(this.file);
    }

    protected String lock(Session<?> session, LockPatternService patterns) throws BackgroundException {
        Set<Path> locks = patterns.derive(this.file);
        for (Path lock : locks) {
            if (this.owners.contains((Object)new FilesystemCacheReference(lock))) {
                log.warn(String.format("Skip looking for lock owner file %s on server created previously", lock));
                continue;
            }
            try {
                PathAttributes attr = ((AttributesFinder)session.getFeature(AttributesFinder.class)).find(lock);
                if (!new FilesystemListFilter().accept(attr)) continue;
                log.warn(String.format("Found lock owner file %s matching file %s", lock, this.file));
                throw new LockedException(String.format("File %s is already locked by third party", this.file.getName()));
            }
            catch (NotfoundException notfoundException) {
            }
        }
        String random = new AlphanumericRandomStringService().random();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return pseudo lock %s for file %s", random, this.file));
        }
        return random;
    }

    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString((String)"Lock {0}", (String)"Status"), this.file.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FilesystemLockWorker that = (FilesystemLockWorker)((Object)o);
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemLockWorker{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

