/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemWriters;
import ch.iterate.mountainduck.fs.InternalListProgressListener;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemListWorker
extends SessionListWorker {
    private static final Logger log = LogManager.getLogger((String)FilesystemListWorker.class.getName());
    private final FilesystemOperations<?> fs;
    private final FilesystemBuffers buffers;
    private final FilesystemWriters writers;
    private final Path directory;
    private final FilesystemListProgressListener listener;
    private final FilesystemCache cache;
    private Boolean caching = false;
    private Long expiry = -1L;

    public FilesystemListWorker(FilesystemOperations<?> fs, FilesystemBuffers buffers, FilesystemWriters writers, FilesystemCache cache, Path directory, FilesystemListProgressListener listener) {
        super((Cache)cache, directory, (ListProgressListener)new InternalListProgressListener(fs, writers, listener, new FilesystemListFilter()));
        this.fs = fs;
        this.buffers = buffers;
        this.writers = writers;
        this.cache = cache;
        this.directory = directory;
        this.listener = listener;
    }

    public FilesystemListWorker withCache(boolean enabled) {
        this.caching = enabled;
        return this;
    }

    public FilesystemListWorker withCacheExpiry(long timeout) {
        this.expiry = timeout;
        return this;
    }

    public boolean isCached() {
        if (new TemporaryFileMarker().contains(this.directory)) {
            return true;
        }
        if (this.caching.booleanValue()) {
            AttributedList list;
            Long timestamp;
            boolean cached = super.isCached();
            if (-1L == this.expiry) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Expiry disabled for cache of %s", this.directory));
                }
            } else if (cached && (timestamp = (list = this.cache.get((Referenceable)this.directory)).attributes().getTimestamp()) + this.expiry < System.currentTimeMillis()) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Cache for %s from %d expired", this.directory, timestamp));
                }
                return false;
            }
            if (cached && log.isInfoEnabled()) {
                log.info(String.format("Return cached directory listing for %s", this.directory));
            }
            return cached;
        }
        return false;
    }

    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        try {
            this.listener.reset();
            return super.run(session).filter((Filter)new FilesystemListFilter());
        }
        catch (BackgroundException e) {
            log.warn(String.format("Notify listener %s of error %s", new Object[]{this.listener, e}));
            this.listener.error(e);
            throw e;
        }
    }

    public void cleanup(AttributedList<Path> list) {
        if (AttributedList.emptyList() == list) {
            log.warn(String.format("Cancel cleanup of worker for %s", this.directory));
        } else if (this.isCanceled()) {
            log.warn(String.format("Notify listener %s with partial directory listing for %s", this.listener, this.directory));
            this.listener.error((BackgroundException)((Object)new ListCanceledException(list)));
        } else {
            for (FilesystemCacheReference reference : this.writers.keySet()) {
                if (!reference.getFile().getParent().equals((Object)this.directory)) continue;
                if (!list.contains((Referenceable)reference.getFile())) {
                    log.debug(String.format("Add missing open reference %s to directory listing from server", new Object[]{reference}));
                    list.add((Referenceable)reference.getFile());
                    continue;
                }
                log.warn(String.format("Replace open reference %s from writer in directory listing from server", new Object[]{reference}));
                list.set(list.indexOf((Referenceable)reference.getFile()), (Referenceable)reference.getFile());
            }
            Set<Path> buffered = this.buffers.find(this.directory);
            for (Path f : buffered) {
                if (!new TemporaryFileMarker().contains(f) || list.contains((Referenceable)f)) continue;
                log.debug(String.format("Add missing buffered file %s to directory listing from server", f));
                list.add((Referenceable)f);
            }
            try {
                this.listener.chunk(this.directory, list);
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                // empty catch block
            }
            super.cleanup(list);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Notify listener %s for %s", this.listener, this.directory));
        }
        this.listener.finish();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemListWorker{");
        sb.append("fs=").append(this.fs);
        sb.append(", directory=").append(this.directory);
        sb.append(", caching=").append(this.caching);
        sb.append(", timeout=").append(this.expiry);
        sb.append('}');
        return sb.toString();
    }
}

