/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.RegexFilesystemFilenameBlacklist;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FilesystemListFilter
extends NullFilter<Path> {
    private static final Logger log = LogManager.getLogger((String)FilesystemListFilter.class.getName());
    private final FilesystemFilenameBlacklist classes = new StorageClassFilter();
    private final FilesystemFilenameBlacklist types = new TypeFilter();
    private final FilesystemFilenameBlacklist names = new RegexFilesystemFilenameBlacklist(PreferencesFactory.get().getList("fs.filenames.filter.name.regexp"));

    public boolean accept(Path file) {
        if (this.names.contains(file)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Filter file %s by name", file));
            }
            return false;
        }
        if (this.types.contains(file)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Filter file %s by type", file));
            }
            return false;
        }
        if (this.classes.contains(file)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Filter file %s by storage class", file));
            }
            return false;
        }
        return this.accept(file.attributes());
    }

    public boolean accept(PathAttributes attributes) {
        if (attributes.isDuplicate()) {
            return false;
        }
        return attributes.isHidden() == false;
    }

    private static final class StorageClassFilter
    extends RegexFilesystemFilenameBlacklist {
        public StorageClassFilter() {
            super(PreferencesFactory.get().getList("fs.filenames.filter.storageclass.regexp"));
        }

        @Override
        public boolean contains(Path file) {
            if (StringUtils.isBlank((CharSequence)file.attributes().getStorageClass())) {
                return false;
            }
            return this.contains(file.attributes().getStorageClass());
        }
    }

    private static final class TypeFilter
    extends RegexFilesystemFilenameBlacklist {
        public TypeFilter() {
            super(PreferencesFactory.get().getList("fs.filenames.filter.types.regexp"));
        }

        @Override
        public boolean contains(Path file) {
            for (AbstractPath.Type type : file.getType()) {
                if (!super.contains(type.name())) continue;
                return true;
            }
            return false;
        }
    }
}

