/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemIncrementalListProgressListener
implements FilesystemListProgressListener {
    private static final Logger log = LogManager.getLogger((String)FilesystemIncrementalListProgressListener.class.getName());
    private final Host bookmark;
    private final ProgressListener progress;
    private final BlockingDeque<Path> queue = new LinkedBlockingDeque<Path>();
    private final AtomicInteger index = new AtomicInteger(0);
    private static final Path POISON = new Path(UUID.randomUUID().toString(), EnumSet.noneOf(AbstractPath.Type.class)){

        public String toString() {
            return "EOF";
        }
    };
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();
    private BackgroundException failure;

    public FilesystemIncrementalListProgressListener(Host bookmark) {
        this(bookmark, (ProgressListener)new DisabledProgressListener());
    }

    public FilesystemIncrementalListProgressListener(Host bookmark, ProgressListener progress) {
        this.bookmark = bookmark;
        this.progress = progress;
    }

    public void chunk(Path folder, AttributedList<Path> list) {
        for (int i = this.index.get(); i < list.size(); ++i) {
            this.queue.offerLast((Path)list.get(i));
        }
        this.index.set(list.size());
    }

    @Override
    public FilesystemListProgressListener reset() {
        this.index.set(0);
        this.queue.clear();
        this.failure = null;
        return this;
    }

    @Override
    public void error(BackgroundException e) {
        this.failure = e;
    }

    @Override
    public void finish() {
        this.queue.offerLast(POISON);
        this.lock.lock();
        try {
            this.done.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean hasNext() {
        Path peek = (Path)this.queue.peekFirst();
        if (null == peek) {
            return false;
        }
        return POISON != peek;
    }

    @Override
    public Path next() throws BackgroundException {
        Path next = (Path)Uninterruptibles.takeUninterruptibly(this.queue);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return next %s", next));
        }
        if (next == POISON) {
            this.queue.offerLast(POISON);
            if (this.failure != null) {
                throw this.failure;
            }
            return null;
        }
        return next;
    }

    @Override
    public void await() throws BackgroundException {
        this.lock.lock();
        try {
            while (this.queue.peekLast() != POISON) {
                log.warn(String.format("Await result for %s", this));
                Uninterruptibles.awaitUninterruptibly((Condition)this.done, (Duration)Duration.ofMinutes(1L));
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.failure != null) {
            throw this.failure;
        }
    }

    @Override
    public Path search(String filename) throws BackgroundException {
        Path next;
        Comparator comparator = this.bookmark.getProtocol().getListComparator();
        while ((next = this.next()) != null) {
            if (this.bookmark.getProtocol().getCaseSensitivity() == Protocol.Case.sensitive ? StringUtils.equals((CharSequence)filename, (CharSequence)next.getName()) : StringUtils.equalsIgnoreCase((CharSequence)filename, (CharSequence)next.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found %s in partial directory listing", next));
                }
                return next;
            }
            if (comparator.compare(next.getName(), filename) <= 0) continue;
            log.debug(String.format("%s is lexicographically greater. Assume not found for %s.", next.getName(), filename));
            throw new NotfoundException(filename);
        }
        throw new NotfoundException(filename);
    }

    public void message(String status) {
        this.progress.message(status);
    }
}

