/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.iterate.mountainduck.exception.DirectoryNotEmptyException;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemListFilter;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FilesystemDeleteWorker
extends DeleteWorker {
    private final FilesystemOperations<?> fs;
    private final FilesystemCache cache;
    private final Path file;

    public FilesystemDeleteWorker(Controller controller, FilesystemOperations<?> fs, FilesystemCache cache, Path file, boolean trash) {
        super(LoginCallbackFactory.get((Controller)controller), Collections.singletonList(file), (ProgressListener)controller, (Filter)new NullFilter(), trash);
        this.fs = fs;
        this.cache = cache;
        this.file = file;
    }

    protected Map<Path, TransferStatus> compile(Host host, Delete delete, ListService list, ListProgressListener listener, Path file) throws BackgroundException {
        try {
            Map files = super.compile(host, delete, list, listener, file);
            for (Path f : files.keySet()) {
                AttributedList chunk;
                if (!f.isDirectory() || file.isSymbolicLink() || !this.cache.isCached((Referenceable)f) || (chunk = this.cache.get((Referenceable)f)).filter((Filter)new FilesystemListFilter()).isEmpty()) continue;
                throw new ListCanceledException(chunk);
            }
            return files;
        }
        catch (ListCanceledException e) {
            throw new DirectoryNotEmptyException(file.getAbsolute(), e);
        }
    }

    protected String getLockId(Path file) {
        return this.fs.getLock(file);
    }

    public void cleanup(List<Path> deleted) {
        for (Path f : deleted) {
            this.cache.delete(f);
        }
        super.cleanup(deleted);
    }

    public List<Path> run(Session<?> session) throws BackgroundException {
        TemporaryFileMarker marker = new TemporaryFileMarker();
        if (marker.contains(this.file)) {
            return Collections.singletonList(marker.remove(this.file));
        }
        super.run(session);
        return Collections.singletonList(this.file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemDeleteWorker{");
        sb.append("fs=").append(this.fs);
        sb.append(", file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

