/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.worker.CreateVaultWorker;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.service.VaultService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemCreateVaultWorker
extends CreateVaultWorker {
    private static final Logger log = LogManager.getLogger((String)FilesystemCreateVaultWorker.class.getName());
    private final FilesystemOperations<?> fs;
    private final VaultService.Callback callback;

    public FilesystemCreateVaultWorker(FilesystemOperations<?> fs, String region, VaultCredentials passphrase, Vault vault, VaultService.Callback callback) {
        super(region, passphrase, (PasswordStore)PasswordStoreFactory.get(), vault);
        this.fs = fs;
        this.callback = callback;
    }

    public Path run(Session<?> session) throws BackgroundException {
        Path target = super.run(session);
        long time = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update creation date in attributes for %s to %d", target, time));
        }
        target.attributes().setAccessedDate(time);
        target.attributes().setCreationDate(time);
        target.attributes().setModificationDate(time);
        this.fs.invalidate(target.getParent());
        return target;
    }

    public void cleanup(Path vault) {
        this.callback.done(vault);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemCreateVaultWorker{");
        sb.append("fs=").append(this.fs);
        sb.append('}');
        return sb.toString();
    }
}

