/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.worker.CreateDirectoryWorker;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.exception.FileAlreadyExistsException;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.service.RegionService;
import ch.iterate.mountainduck.service.RegionServiceFactory;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemCreateDirectoryWorker
extends Worker<Path> {
    private static final Logger log = LogManager.getLogger((String)FilesystemCreateDirectoryWorker.class.getName());
    private final FilesystemCache cache;
    private final Path directory;

    public FilesystemCreateDirectoryWorker(FilesystemCache cache, Path directory) {
        this.cache = cache;
        this.directory = directory;
    }

    public Path run(Session<?> session) throws BackgroundException {
        try {
            RegionService prompt;
            Location.Name name;
            Location location;
            CachingFindFeature finder = new CachingFindFeature((Cache)this.cache, (Find)new DefaultFindFeature(session));
            if (finder.find(this.directory)) {
                throw new FileAlreadyExistsException(this.directory.getAbsolute());
            }
            String region = null;
            if (((PathContainerService)session.getFeature(PathContainerService.class)).isContainer(this.directory) && (location = (Location)session.getFeature(Location.class)) != null && !location.getLocations().isEmpty() && (name = (prompt = RegionServiceFactory.get()).select(location.getLocations(), location.getDefault())) != null) {
                region = name.getIdentifier();
            }
            Path target = new CreateDirectoryWorker(this.directory, region).run(session);
            long time = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Update creation date in attributes for %s to %d", this.directory, time));
            }
            target.attributes().setAccessedDate(time);
            target.attributes().setCreationDate(time);
            target.attributes().setModificationDate(time);
            return target;
        }
        catch (NotfoundException e) {
            throw new AccessDeniedException(e.getDetail(), (Throwable)e);
        }
    }

    public void cleanup(Path directory) {
        this.cache.add((Object)this, directory);
        this.cache.put((Referenceable)directory, new AttributedList());
        super.cleanup((Object)directory);
    }

    public Path initialize() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesystemCreateDirectoryWorker)) {
            return false;
        }
        FilesystemCreateDirectoryWorker that = (FilesystemCreateDirectoryWorker)((Object)o);
        return Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return Objects.hash(this.directory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemCreateDirectoryWorker{");
        sb.append("directory=").append(this.directory);
        sb.append('}');
        return sb.toString();
    }
}

