/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public interface FilesystemCallbacks<Inode> {
    public static final Quota.Space QUOTA_UNKNOWN = new Quota.Space(Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE));

    public void invalidate(Path var1);

    public FilesystemCallbacks<Inode> open(Path var1, Local var2) throws BackgroundException;

    public void close() throws BackgroundException;

    default public Path find(Path directory, String filename) throws BackgroundException {
        return this.find(directory, filename, Flags.online);
    }

    public Path find(Path var1, String var2, Flags var3) throws BackgroundException;

    public MarkerBuffer buffer(Path var1) throws BackgroundException;

    public void open(Path var1, Mode var2, Long var3, Application var4) throws BackgroundException;

    public boolean contains(Path var1, Mode var2) throws BackgroundException;

    default public TransferStatus close(Path file, Mode flags, Application application) throws BackgroundException {
        return this.close(file, flags, application, true);
    }

    public TransferStatus close(Path var1, Mode var2, Application var3, boolean var4) throws BackgroundException;

    public Inode touch(Path var1) throws BackgroundException;

    public void truncate(Path var1, long var2) throws BackgroundException;

    public Inode mkdir(Path var1) throws BackgroundException;

    public Inode symlink(Path var1, Path var2) throws BackgroundException;

    public Map<Path, Path> rename(Path var1, Path var2) throws BackgroundException;

    public Set<Path> delete(Path var1) throws BackgroundException;

    public Worker<AttributedList<Path>> list(Path var1, FilesystemListProgressListener var2, long var3) throws BackgroundException;

    public EnumSet<AbstractPath.Type> type(Path var1);

    default public PathAttributes getattr(Path file) throws BackgroundException {
        return this.getattr(file, true);
    }

    public PathAttributes getattr(Path var1, boolean var2) throws BackgroundException;

    public boolean setattr(Path var1, long var2) throws BackgroundException;

    public boolean setattr(Path var1, Permission var2) throws BackgroundException;

    public int read(Path var1, byte[] var2, long var3, int var5) throws BackgroundException;

    public static int read(InputStream input, byte[] buffer) throws IOException {
        return FilesystemCallbacks.read(input, buffer, 0, buffer.length);
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0; remaining -= count) {
            int location = length - remaining;
            count = input.read(buffer, offset + location, remaining);
            if (-1 != count) continue;
            if (remaining != length) break;
            return -1;
        }
        return length - remaining;
    }

    public int write(Path var1, byte[] var2, int var3, long var4) throws BackgroundException;

    public Quota.Space quota(Path var1) throws BackgroundException;

    public Object lock(Path var1) throws BackgroundException;

    public void unlock(Path var1) throws BackgroundException;

    public String getLock(Path var1);

    public static enum Flags {
        online,
        offline;

    }

    public static enum Mode {
        read,
        write,
        write_truncate;

    }
}

