/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.fs.FilesystemAttributesWorker;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemCachingAttributesWorker
extends FilesystemAttributesWorker {
    private static final Logger log = LogManager.getLogger((String)FilesystemCachingAttributesWorker.class.getName());
    private final FilesystemCache cache;
    private final Path file;
    private static final String TIMESTAMP_PROPERTY = "Worker Timestamp";
    private Boolean caching = false;
    private Long expiry = -1L;

    public FilesystemCachingAttributesWorker(FilesystemCache cache, Path file) {
        super(file);
        this.cache = cache;
        this.file = file;
    }

    @Override
    public PathAttributes run(Session<?> session) throws BackgroundException {
        if (this.isCached()) {
            log.warn(String.format("Skip reading attributes for %s", this.file));
            return this.file.attributes();
        }
        return super.run(session).withCustom(TIMESTAMP_PROPERTY, String.valueOf(System.currentTimeMillis()));
    }

    public void cleanup(PathAttributes result) {
        if (!PathAttributes.EMPTY.equals((Object)result)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Swap cache for %s", this.file));
            }
            this.cache.swap(this.file, this.file.withAttributes(result));
        }
    }

    public FilesystemCachingAttributesWorker withCache(boolean enabled) {
        this.caching = enabled;
        return this;
    }

    public FilesystemCachingAttributesWorker withCacheExpiry(long timeout) {
        this.expiry = timeout;
        return this;
    }

    protected boolean isCached() {
        if (new TemporaryFileMarker().contains(this.file)) {
            return true;
        }
        if (this.caching.booleanValue() && this.file.attributes().getCustom().containsKey(TIMESTAMP_PROPERTY)) {
            Long timestamp = Long.valueOf((String)this.file.attributes().getCustom().get(TIMESTAMP_PROPERTY));
            if (timestamp + this.expiry < System.currentTimeMillis()) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Cache for %s from %d expired", this.file, timestamp));
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

