/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import ch.iterate.mountainduck.fs.buffer.DefaultMarkerBufferFactory;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.buffer.MarkerBufferFactory;
import ch.iterate.mountainduck.fs.buffer.NullBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FilesystemBuffers {
    private static final Logger log = LogManager.getLogger((String)FilesystemBuffers.class.getName());
    private final MarkerBufferFactory bufferFactory = new DefaultMarkerBufferFactory();
    private final Map<FilesystemCacheReference, MarkerBuffer> buffers = new ConcurrentHashMap<FilesystemCacheReference, MarkerBuffer>(1);

    public synchronized void clear() {
        for (MarkerBuffer buffer : this.buffers.values()) {
            buffer.close();
        }
        this.buffers.clear();
    }

    public synchronized MarkerBuffer getOrCreate(Path file) {
        if (!this.buffers.containsKey((Object)new FilesystemCacheReference(file))) {
            MarkerBuffer buffer = this.bufferFactory.create(file);
            if (log.isInfoEnabled()) {
                log.info(String.format("Set buffer %s for file %s", buffer, file));
            }
            this.buffers.put(new FilesystemCacheReference(file), buffer);
            return buffer;
        }
        return this.buffers.get((Object)new FilesystemCacheReference(file));
    }

    public synchronized MarkerBuffer get(Path file) {
        if (this.buffers.containsKey((Object)new FilesystemCacheReference(file))) {
            return this.buffers.get((Object)new FilesystemCacheReference(file));
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("No buffer open for file %s", file));
        }
        return new NullBuffer();
    }

    public synchronized boolean contains(Path file) {
        return this.buffers.containsKey((Object)new FilesystemCacheReference(file));
    }

    public synchronized void put(Path file, MarkerBuffer buffer) {
        this.buffers.put(new FilesystemCacheReference(file), buffer);
    }

    public synchronized MarkerBuffer remove(Path file) {
        MarkerBuffer buffer = this.buffers.remove((Object)new FilesystemCacheReference(file));
        if (buffer != null) {
            return buffer;
        }
        return new NullBuffer();
    }

    public Collection<MarkerBuffer> list() {
        return this.buffers.values();
    }

    public Set<Path> find(Path directory) {
        HashSet<Path> files = new HashSet<Path>();
        for (FilesystemCacheReference file : this.buffers.keySet()) {
            if (!new FilesystemCacheReference(file.getFile().getParent()).test(directory)) continue;
            files.add(file.getFile());
        }
        return files;
    }
}

