/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.worker.Worker;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemAttributesWorker
extends Worker<PathAttributes> {
    private static final Logger log = LogManager.getLogger((String)FilesystemAttributesWorker.class.getName());
    private final Path file;

    public FilesystemAttributesWorker(Path file) {
        this.file = new Path(file);
        PathAttributes attr = new PathAttributes(file.attributes()).withVersionId(null).withFileId(null);
        this.file.withAttributes(attr);
    }

    public PathAttributes run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Read latest attributes for file %s", this.file));
        }
        AttributesFinder find = (AttributesFinder)session.getFeature(AttributesFinder.class);
        PathAttributes attr = find.find(this.file);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return %s for file %s", attr, this.file));
        }
        return attr;
    }

    public PathAttributes initialize() {
        return PathAttributes.EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesystemAttributesWorker)) {
            return false;
        }
        FilesystemAttributesWorker that = (FilesystemAttributesWorker)((Object)o);
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilesystemAttributesWorker{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

