/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.iterate.mountainduck.exception.BackgroundExceptionCache;
import ch.iterate.mountainduck.exception.ExceptionCache;
import ch.iterate.mountainduck.fs.ConnectCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilesystemAlertCallback
implements AlertCallback {
    private static final Logger log = LogManager.getLogger((String)FilesystemAlertCallback.class.getName());
    private final NotificationService notification = NotificationServiceFactory.get();
    private final FailureDiagnostics<BackgroundException> diagnostics = new DefaultFailureDiagnostics();
    private final ExceptionCache<BackgroundException> failures = new BackgroundExceptionCache();
    private final AlertCallback alert;
    private final ConnectCallback connect;

    public FilesystemAlertCallback(AlertCallback alert, ConnectCallback connect) {
        this.alert = alert;
        this.connect = connect;
    }

    public boolean alert(Host bookmark, BackgroundException failure, StringBuilder transcript) {
        if (log.isDebugEnabled()) {
            log.debug(transcript.toString());
        }
        switch (this.diagnostics.determine((Object)failure)) {
            case network: {
                if (PreferencesFactory.get().getBoolean("connection.alert.notification.enable")) {
                    this.notification.notify(BookmarkNameProvider.toString((Host)bookmark), bookmark.getUuid(), failure.getMessage(), bookmark.getHostname());
                }
            }
            case unsupported: {
                return false;
            }
            case application: 
            case quota: {
                if (failure instanceof NotfoundException || failure instanceof AccessDeniedException) {
                    log.warn(String.format("%s. %s", failure.getMessage(), failure.getDetail()));
                    return false;
                }
                if (this.failures.contains(bookmark, failure)) {
                    log.error(String.format("Raise error for repeated failure %s", new Object[]{failure}));
                    return false;
                }
                this.failures.add(bookmark, failure);
                return this.alert.alert(bookmark, failure, transcript);
            }
            case login: 
            case cancel: {
                if (null == failure.getCause()) {
                    log.warn(String.format("Disconnect bookmark %s for failure %s", new Object[]{bookmark, failure}));
                    this.connect.disconnect(bookmark);
                } else {
                    log.error(String.format("Unhandled error %s", new Object[]{failure}));
                }
                return false;
            }
        }
        return false;
    }
}

