/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WriteAclWorker;
import java.util.Collections;

public class FilesystemAclWorker
extends WriteAclWorker {
    public FilesystemAclWorker(Path file, Permission permission) {
        super(Collections.singletonList(file), FilesystemAclWorker.toAcl(permission), (Worker.RecursiveCallback)new BooleanRecursiveCallback(false), (ProgressListener)new DisabledProgressListener());
    }

    public Boolean run(Session<?> session) throws BackgroundException {
        AclPermission feature = (AclPermission)session.getFeature(AclPermission.class);
        if (null == feature) {
            throw new UnsupportedException(String.format("%s feature not supported for %s", AclPermission.class.getName(), session.getHost().getProtocol()));
        }
        try {
            if (super.run(session).booleanValue()) {
                return true;
            }
            throw new UnsupportedException(String.format("%s feature not supported for %s", UnixPermission.class.getName(), session.getHost().getProtocol()));
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException e) {
            throw new UnsupportedException(e);
        }
    }

    protected static Acl toAcl(Permission permission) {
        Acl acl = new Acl(new Acl.UserAndRole[0]);
        if (permission.getOther().implies(Permission.Action.read)) {
            acl.addAll((Acl.User)new Acl.GroupUser("AllUsers"), new Acl.Role[]{new Acl.Role("READ")});
        }
        if (permission.getGroup().implies(Permission.Action.read)) {
            acl.addAll((Acl.User)new Acl.GroupUser("AllAuthenticatedUsers"), new Acl.Role[]{new Acl.Role("READ")});
        }
        if (permission.getGroup().implies(Permission.Action.write)) {
            acl.addAll((Acl.User)new Acl.GroupUser("AllAuthenticatedUsers"), new Acl.Role[]{new Acl.Role("WRITE")});
        }
        return acl;
    }
}

