/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import ch.iterate.mountainduck.fs.PathFilenameComposer;
import ch.iterate.mountainduck.fs.badge.FileOverlayIconService;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.service.DisabledReloadService;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.queue.SyncQueue;

public interface Filesystem {
    default public void mount(Path workdir) throws BackgroundException {
        this.mount(workdir, Options.readwrite);
    }

    public void mount(Path var1, Options var2) throws BackgroundException;

    public void unmount() throws BackgroundException;

    public Local getMountpoint();

    default public State getMountStatus() {
        return this.getOperations().getMountStatus();
    }

    default public Host getHost() {
        return this.getPool().getHost();
    }

    default public ConnectMode getMode() {
        return this.getOperations().getMode();
    }

    public FilesystemOperations<?> getOperations();

    default public FilesystemSessionPool getPool() {
        return this.getOperations().getPool();
    }

    default public <T> T getFeature(Class<T> type) {
        return this.getOperations().getFeature(type);
    }

    default public FilesystemCache getCache() {
        return this.getOperations().getCache();
    }

    default public LocalCache<?> getLocalCache() {
        return this.getOperations().getLocalCache();
    }

    default public DirectoryIndexer getIndexer() {
        return this.getOperations().getIndexer();
    }

    default public SyncQueue getQueue() {
        return this.getOperations().getQueue();
    }

    default public VaultRegistry getVault() {
        return this.getOperations().getVault();
    }

    default public FileHistory getHistory() {
        return this.getOperations().getHistory();
    }

    default public MetadataService<?> getMetadataService() {
        return this.getOperations().getMetadataService();
    }

    default public FilesystemDirectoryGenerations getGenerations() {
        return this.getOperations().getGenerations();
    }

    default public FileOverlayIconService.Badge getBadge(Path file) {
        return this.getOperations().getBadge(file);
    }

    default public FileStatusService.Status getStatus(Path file) {
        return this.getOperations().getStatus(file);
    }

    default public PathFilenameComposer getComposer() {
        return this.getOperations().getComposer();
    }

    default public ReloadService getReloadService() {
        return new DisabledReloadService();
    }

    public static enum Options {
        readwrite,
        readonly;

    }

    public static enum State {
        closed,
        busy,
        idle;

    }
}

