/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class FilenameMatchPathPredicate
implements CacheReference<Path> {
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    private final String path;
    private final Protocol.Case sensitivity;

    public FilenameMatchPathPredicate(Path file) {
        this(file, Protocol.Case.sensitive);
    }

    public FilenameMatchPathPredicate(Path file, Protocol.Case sensitivity) {
        this.sensitivity = sensitivity;
        this.path = normalizer.normalize((CharSequence)(sensitivity == Protocol.Case.sensitive ? file.getAbsolute() : StringUtils.lowerCase((String)file.getAbsolute()))).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilenameMatchPathPredicate)) {
            return false;
        }
        FilenameMatchPathPredicate that = (FilenameMatchPathPredicate)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean test(Path file) {
        return this.equals(new FilenameMatchPathPredicate(file, this.sensitivity));
    }

    public boolean isChild(Path directory) {
        if (directory.isRoot()) {
            return true;
        }
        if (StringUtils.equals((CharSequence)PathNormalizer.parent((String)this.path, (char)'/'), (CharSequence)PathNormalizer.parent((String)new FilenameMatchPathPredicate((Path)directory, (Protocol.Case)this.sensitivity).path, (char)'/'))) {
            return false;
        }
        return StringUtils.startsWith((CharSequence)this.path, (CharSequence)PathNormalizer.parent((String)new FilenameMatchPathPredicate((Path)directory, (Protocol.Case)this.sensitivity).path, (char)'/'));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilenameMatchPathPredicate{");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", sensitivity=").append(this.sensitivity);
        sb.append('}');
        return sb.toString();
    }
}

