/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.VolumeService;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryVolumeService
implements VolumeService {
    private static final Logger log = LogManager.getLogger((String)DirectoryVolumeService.class.getName());
    private final Set<Local> locked = new CopyOnWriteArraySet<Local>();

    @Override
    public Local borrow(Host bookmark) {
        Local mountpoint = LocalFactory.get((String)PreferencesFactory.get().getProperty("mount.directory"));
        return this.borrow(bookmark, mountpoint);
    }

    protected Local borrow(Host bookmark, Local mountpoint) {
        return this.borrow(LocalFactory.get((Local)mountpoint.withBookmark(PreferencesFactory.get().getProperty("mount.directory.bookmark")), (String)StringUtils.trim((String)RegExUtils.replaceAll((String)BookmarkNameProvider.toString((Host)bookmark), (String)"[^.A-Za-z0-9\u2013 -]", (String)""))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Local borrow(Local volume) {
        String parent = volume.getParent().getAbsolute();
        int no = 1;
        Set<Local> set = this.locked;
        synchronized (set) {
            while (this.isLocked(volume)) {
                volume = this.propose(volume.getName(), parent, no);
                ++no;
            }
        }
        this.lock(volume);
        return volume;
    }

    protected Local propose(String name, String parent, int no) {
        String proposal = String.format("%s-%d", name, no);
        Local directory = LocalFactory.get((String)parent, (String)proposal);
        return directory;
    }

    protected void lock(Local directory) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Lock volume %s", directory));
        }
        this.locked.add(directory);
    }

    @Override
    public void release(Local volume) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Release volume %s", volume));
        }
        this.locked.remove(volume);
    }

    protected boolean isLocked(Local directory) {
        return this.locked.contains(directory);
    }
}

