/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.CertificateIdentityCallbackFactory;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.CertificateTrustCallbackFactory;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallbackFactory;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.LoginConnectionService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordCallbackFactory;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultRegistryFactory;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.ConnectCallback;
import ch.iterate.mountainduck.fs.FilesystemSessionPool;
import ch.iterate.mountainduck.threading.BlockingWorkerExecutor;
import ch.iterate.mountainduck.threading.ThreadedWorkerExecutor;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultFilesystemSessionPool
implements FilesystemSessionPool {
    private static final Logger log = LogManager.getLogger((String)DefaultFilesystemSessionPool.class.getName());
    private final BackgroundActionRegistry registry = new BackgroundActionRegistry();
    private final BlockingWorkerExecutor blockingWorkerExecutor;
    private final ThreadedWorkerExecutor threadedWorkerExecutor;
    protected final SessionPool proxy;

    public DefaultFilesystemSessionPool(Controller controller, Host bookmark, ConnectCallback connect) {
        this(controller, connect, SessionPoolFactory.create((ConnectionService)new LoginConnectionService(LoginCallbackFactory.get((Controller)controller), HostKeyCallbackFactory.get((Controller)controller, (Protocol)bookmark.getProtocol()), PasswordStoreFactory.get(), (ProgressListener)controller), (TranscriptListener)controller, (Host)bookmark, (X509TrustManager)new KeychainX509TrustManager(CertificateTrustCallbackFactory.get((Controller)controller), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(bookmark), CertificateStoreFactory.get()), (X509KeyManager)new KeychainX509KeyManager(CertificateIdentityCallbackFactory.get((Controller)controller), bookmark, CertificateStoreFactory.get()), (VaultRegistry)VaultRegistryFactory.create((HostPasswordStore)PasswordStoreFactory.get(), (PasswordCallback)PasswordCallbackFactory.get((Controller)controller)), (SessionPoolFactory.Usage[])new SessionPoolFactory.Usage[0]));
    }

    public DefaultFilesystemSessionPool(Controller controller, ConnectCallback connect, SessionPool proxy) {
        this.proxy = proxy;
        this.blockingWorkerExecutor = new BlockingWorkerExecutor(controller, proxy.getHost(), connect, this.registry);
        this.threadedWorkerExecutor = new ThreadedWorkerExecutor(controller, proxy.getHost(), connect, this.registry);
    }

    @Override
    public Session<?> borrow() throws BackgroundException {
        return this.borrow(BackgroundActionState.running);
    }

    public void release(Session<?> session, BackgroundException failure) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Release session %s to pool %s", session, this.proxy));
        }
        try {
            this.proxy.release(session, failure);
        }
        catch (IllegalStateException e) {
            log.debug(String.format("Failed to release session %s. %s", session, e.getMessage()));
        }
    }

    public Session<?> borrow(BackgroundActionState callback) throws BackgroundException {
        try {
            Session session;
            try {
                session = this.proxy.borrow(callback);
            }
            catch (NoSuchElementException e) {
                if (e.getCause() instanceof BackgroundException) {
                    throw (BackgroundException)e.getCause();
                }
                throw new BackgroundException("Timeout borrowing session from pool", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Borrow session %s from pool %s", session, this.proxy));
            }
            return session;
        }
        catch (BackgroundException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw new ConnectionCanceledException((Throwable)e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof BackgroundException) {
                throw (BackgroundException)e.getCause();
            }
            throw new BackgroundException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T> Future<T> execute(Worker<T> worker) throws BackgroundException {
        return this.threadedWorkerExecutor.run(worker, this.proxy);
    }

    @Override
    public <T> T await(Worker<T> worker) throws BackgroundException {
        return this.await(worker, this);
    }

    @Override
    public <T> T await(Worker<T> worker, FilesystemSessionPool pool) throws BackgroundException {
        return this.await(this.blockingWorkerExecutor.run(worker, pool));
    }

    private <T> T await(Future<T> task) throws BackgroundException {
        try {
            return task.get();
        }
        catch (InterruptedException e) {
            log.error(String.format("Failure executing worker %s. %s", this, e.getMessage()));
            throw new BackgroundException((Throwable)e);
        }
        catch (ExecutionException e) {
            log.error(String.format("Failure executing worker %s. %s", this, e.getMessage()));
            if (e.getCause() instanceof BackgroundException) {
                throw (BackgroundException)e.getCause();
            }
            throw new BackgroundException(e.getCause());
        }
    }

    public void evict() {
        this.proxy.evict();
    }

    public Host getHost() {
        return this.proxy.getHost();
    }

    public VaultRegistry getVault() {
        return this.proxy.getVault();
    }

    @Override
    public void release(Session<?> session) {
        this.release(session, null);
    }

    public void shutdown() {
        for (BackgroundAction action : (BackgroundAction[])this.registry.toArray((Object[])new BackgroundAction[this.registry.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.proxy.shutdown();
        this.blockingWorkerExecutor.shutdown();
        this.threadedWorkerExecutor.shutdown();
    }

    public Session.State getState() {
        return this.proxy.getState();
    }

    public <T> T getFeature(Class<T> type) {
        return (T)this.proxy.getFeature(type);
    }
}

