/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.HashMap;

public enum ConnectMode {
    online{

        @Override
        public String tooltip() {
            return LocaleFactory.localizedString((String)"Keep no offline copy and download files on demand.", (String)"Disk");
        }

        public String toString() {
            return LocaleFactory.localizedString((String)"Online", (String)"Disk");
        }
    }
    ,
    selective{

        @Override
        public String tooltip() {
            return LocaleFactory.localizedString((String)"Keep all opened files on your computer and upload changes when server is reachable. Select files and folders to keep always offline in the file explorer.", (String)"Disk");
        }

        public String toString() {
            return LocaleFactory.localizedString((String)"Smart Synchronization", (String)"Disk");
        }
    };

    private static final String PROPERTY = "Sync";

    public abstract String tooltip();

    public static ConnectMode get(Host bookmark) {
        if (ConnectMode.isConfigured(bookmark)) {
            return ConnectMode.valueOf((String)bookmark.getCustom().get(PROPERTY));
        }
        return ConnectMode.valueOf(PreferencesFactory.get().getProperty("fs.sync.mode"));
    }

    public static boolean isConfigured(Host bookmark) {
        return bookmark.getCustom().containsKey(PROPERTY);
    }

    public static void set(Host bookmark, ConnectMode mode) {
        HashMap<String, String> custom = new HashMap<String, String>(bookmark.getCustom());
        if (null == mode) {
            custom.remove(PROPERTY);
        } else {
            custom.put(PROPERTY, mode.name());
        }
        bookmark.setCustom(custom);
    }
}

