/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.LockPatternService;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ChainedLockPatternService
implements LockPatternService {
    private final Preferences preferences = PreferencesFactory.get();
    private final LockPatternService[] chain;

    public ChainedLockPatternService(LockPatternService ... status) {
        this.chain = status;
    }

    @Override
    public Pattern match(Path file) {
        if (!this.preferences.getBoolean("fs.lock.enable")) {
            return null;
        }
        for (LockPatternService service : this.chain) {
            Pattern match = service.match(file);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @Override
    public Set<Path> derive(Path file) {
        if (!this.preferences.getBoolean("fs.lock.enable")) {
            return Collections.emptySet();
        }
        LinkedHashSet<Path> found = new LinkedHashSet<Path>();
        for (LockPatternService service : this.chain) {
            Set<Path> d = service.derive(file);
            if (d == null) continue;
            found.addAll(d);
        }
        return found;
    }
}

