/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.exception;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.exception.ExceptionCache;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class BackgroundExceptionCache
implements ExceptionCache<BackgroundException> {
    private final Map<Host, Set<BackgroundException>> failures = new ConcurrentHashMap<Host, Set<BackgroundException>>();

    @Override
    public void add(Host bookmark, BackgroundException failure) {
        if (!this.failures.containsKey(bookmark)) {
            this.failures.put(bookmark, new HashSet());
        }
        this.failures.get(bookmark).add(failure);
    }

    @Override
    public boolean contains(Host bookmark, BackgroundException failure) {
        if (this.failures.containsKey(bookmark)) {
            Set<BackgroundException> failures = this.failures.get(bookmark);
            for (BackgroundException e : failures) {
                if (null == e || !StringUtils.equals((CharSequence)e.getDetail(), (CharSequence)failure.getDetail())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear(Host bookmark) {
        this.failures.remove(bookmark);
    }
}

