/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.DisabledShutdownTimer;
import ch.iterate.mountainduck.ShutdownTimer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownTimerFactory
extends Factory<ShutdownTimer> {
    private static final Logger log = LogManager.getLogger(ShutdownTimerFactory.class);

    public ShutdownTimerFactory() {
        super("factory.shutdowntimer.class");
    }

    public ShutdownTimer create(Controller controller) {
        String clazz = PreferencesFactory.get().getProperty("factory.shutdowntimer.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{controller.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s", controller.getClass()));
                return (ShutdownTimer)name.newInstance();
            }
            return (ShutdownTimer)constructor.newInstance(controller);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledShutdownTimer();
        }
    }

    public static ShutdownTimer get(Controller c) {
        return new ShutdownTimerFactory().create(c);
    }
}

